/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsException;

public class JMSOperationsProvider {
    private static final String PROPERTY_NAME = "jmsoperations.implementation.class";
    private static final String FILE_NAME = "jmsoperations.properties";

    public static JMSOperations getInstance(ManagementClient client) {
        Object jmsOperationsInstance;
        String className = System.getProperty(PROPERTY_NAME);
        if (className == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            InputStream stream = tccl.getResourceAsStream(FILE_NAME);
            Properties propsFromFile = new Properties();
            try {
                propsFromFile.load(stream);
                className = propsFromFile.getProperty(PROPERTY_NAME);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (className == null) {
            throw new JMSOperationsException("Please specify a property jmsoperations.implementation.class in jmsoperations.properties");
        }
        System.out.println("Creating instance of class: " + className);
        try {
            Class<?> clazz = Class.forName(className);
            jmsOperationsInstance = clazz.getConstructor(ManagementClient.class).newInstance(client);
        }
        catch (Exception e) {
            throw new JMSOperationsException(e);
        }
        if (!(jmsOperationsInstance instanceof JMSOperations)) {
            throw new JMSOperationsException("Class " + className + " does not implement interface JMSOperations");
        }
        return (JMSOperations)jmsOperationsInstance;
    }
}

