/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.test.integration.domain.management.util.Authentication;
import org.jboss.as.test.shared.TimeoutUtil;

public class JBossAsManagedConfiguration
extends CommonContainerConfiguration {
    private String jbossHome = System.getProperty("jboss.home");
    private String javaHome = System.getenv("JAVA_HOME");
    private String controllerJavaHome = System.getenv("JAVA_HOME");
    private String modulePath = System.getProperty("module.path");
    private String javaVmArguments = System.getProperty("server.jvm.args", "-Xmx512m -XX:MaxPermSize=128m");
    private int startupTimeoutInSeconds = TimeoutUtil.adjust((int)120);
    private boolean outputToConsole = true;
    private String hostControllerManagementProtocol = "remote";
    private String hostControllerManagementAddress = System.getProperty("jboss.test.host.master.address", "localhost");
    private int hostControllerManagementPort = 9999;
    private String hostName = "master";
    private String domainDir;
    private String domainConfigFile;
    private String hostConfigFile;
    private String hostCommandLineProperties;
    private boolean adminOnly;
    private boolean readOnlyDomain;
    private boolean readOnlyHost;
    private CallbackHandler callbackHandler = Authentication.getCallbackHandler();
    private String mgmtUsersFile;
    private String mgmtGroupsFile;
    private boolean backupDC;
    private boolean cachedDC;

    public static JBossAsManagedConfiguration createFromClassLoaderResources(String domainConfigPath, String hostConfigPath) {
        JBossAsManagedConfiguration result = new JBossAsManagedConfiguration();
        if (domainConfigPath != null) {
            result.setDomainConfigFile(JBossAsManagedConfiguration.loadConfigFileFromContextClassLoader(domainConfigPath));
        }
        if (hostConfigPath != null) {
            result.setHostConfigFile(hostConfigPath);
        }
        return result;
    }

    public static String loadConfigFileFromContextClassLoader(String resourcePath) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL url = tccl.getResource(resourcePath);
        assert (url != null) : "cannot find resource at path " + resourcePath;
        return new File(JBossAsManagedConfiguration.toURI(url)).getAbsolutePath();
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public JBossAsManagedConfiguration(String jbossHome) {
        if (jbossHome != null) {
            this.jbossHome = jbossHome;
            this.modulePath = new File(jbossHome, "modules").getAbsolutePath();
        }
    }

    public JBossAsManagedConfiguration() {
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome must exist at " + this.jbossHome));
        if (this.javaHome != null) {
            Validate.configurationDirectoryExists((String)this.javaHome, (String)("javaHome must exist at " + this.javaHome));
        }
        if (this.controllerJavaHome != null) {
            Validate.configurationDirectoryExists((String)this.controllerJavaHome, (String)("controllerJavaHome must exist at " + this.controllerJavaHome));
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getControllerJavaHome() {
        return this.controllerJavaHome;
    }

    public void setControllerJavaHome(String controllerJavaHome) {
        this.controllerJavaHome = controllerJavaHome;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getHostControllerManagementProtocol() {
        return this.hostControllerManagementProtocol;
    }

    public void setHostControllerManagementProtocol(String hostControllerManagementProtocol) {
        this.hostControllerManagementProtocol = hostControllerManagementProtocol;
    }

    public String getHostControllerManagementAddress() {
        return this.hostControllerManagementAddress;
    }

    public void setHostControllerManagementAddress(String hostControllerManagementAddress) {
        this.hostControllerManagementAddress = hostControllerManagementAddress;
    }

    public int getHostControllerManagementPort() {
        return this.hostControllerManagementPort;
    }

    public void setHostControllerManagementPort(int hostControllerManagementPort) {
        this.hostControllerManagementPort = hostControllerManagementPort;
    }

    public String getDomainDirectory() {
        return this.domainDir;
    }

    public void setDomainDirectory(String domainDir) {
        this.domainDir = domainDir;
    }

    public String getDomainConfigFile() {
        return this.domainConfigFile;
    }

    public void setDomainConfigFile(String domainConfigFile) {
        this.domainConfigFile = domainConfigFile;
    }

    public String getHostConfigFile() {
        return this.hostConfigFile;
    }

    public void setHostConfigFile(String hostConfigFile) {
        this.hostConfigFile = hostConfigFile;
    }

    public String getMgmtUsersFile() {
        return this.mgmtUsersFile;
    }

    public void setMgmtUsersFile(String mgmtUsersFile) {
        this.mgmtUsersFile = mgmtUsersFile;
    }

    public String getMgmtGroupsFile() {
        return this.mgmtGroupsFile;
    }

    public void setMgmtGroupsFile(String mgmtGroupsFile) {
        this.mgmtGroupsFile = mgmtGroupsFile;
    }

    public String getHostCommandLineProperties() {
        return this.hostCommandLineProperties;
    }

    public void setHostCommandLineProperties(String hostCommandLineProperties) {
        this.hostCommandLineProperties = hostCommandLineProperties;
    }

    public void addHostCommandLineProperty(String hostCommandLineProperty) {
        this.hostCommandLineProperties = this.hostCommandLineProperties == null ? hostCommandLineProperty : this.hostCommandLineProperties + " " + hostCommandLineProperty;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public boolean isReadOnlyDomain() {
        return this.readOnlyDomain;
    }

    public void setReadOnlyDomain(boolean readOnlyDomain) {
        this.readOnlyDomain = readOnlyDomain;
    }

    public boolean isReadOnlyHost() {
        return this.readOnlyHost;
    }

    public void setReadOnlyHost(boolean readOnlyHost) {
        this.readOnlyHost = readOnlyHost;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public boolean isBackupDC() {
        return this.backupDC;
    }

    public void setBackupDC(boolean backupDC) {
        this.backupDC = backupDC;
    }

    public boolean isCachedDC() {
        return this.cachedDC;
    }

    public void setCachedDC(boolean cachedDC) {
        this.cachedDC = cachedDC;
    }
}

