/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.logging.syslogserver;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jboss.as.test.integration.logging.syslogserver.Rfc5424SyslogEvent;
import org.jboss.logging.Logger;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;

public class TCPSyslogSocketHandler
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(TCPSyslogSocketHandler.class);
    protected SyslogServerIF server = null;
    protected Socket socket = null;
    protected Set<Socket> sockets = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPSyslogSocketHandler(Set<Socket> sockets, SyslogServerIF server, Socket socket) {
        this.sockets = sockets;
        this.server = server;
        this.socket = socket;
        Set<Socket> set = this.sockets;
        synchronized (set) {
            this.sockets.add(this.socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream());
            int b = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean firstByte = true;
            boolean octetCounting = false;
            StringBuilder octetLenStr = new StringBuilder();
            block8: do {
                b = bis.read();
                if (firstByte && b >= 49 && b <= 57) {
                    octetCounting = true;
                }
                firstByte = false;
                if (octetCounting) {
                    if (b != 32) {
                        octetLenStr.append((char)b);
                        continue;
                    }
                    int len = Integer.parseInt(octetLenStr.toString());
                    this.handleSyslogMessage(IOUtils.toByteArray((InputStream)bis, (int)len));
                    octetLenStr = new StringBuilder();
                    firstByte = true;
                    octetCounting = false;
                    continue;
                }
                switch (b) {
                    case -1: 
                    case 10: 
                    case 13: {
                        if (baos.size() <= 0) continue block8;
                        this.handleSyslogMessage(baos.toByteArray());
                        baos.reset();
                        firstByte = true;
                        break;
                    }
                    default: {
                        baos.write(b);
                    }
                }
            } while (b != -1);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"IOException occurred", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Socket)this.socket);
            this.sockets.remove(this.socket);
        }
    }

    private void handleSyslogMessage(byte[] rawMsg) {
        Rfc5424SyslogEvent event = new Rfc5424SyslogEvent(rawMsg, 0, rawMsg.length);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Firing Syslog event: " + event));
        }
        List eventHandlers = this.server.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            eventHandler.event(this.server, (SyslogServerEventIF)event);
        }
    }
}

