/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public abstract class AbstractSecurityDomainSetup
implements ServerSetupTask {
    protected static void applyUpdates(ModelControllerClient client, List<ModelNode> updates) {
        for (ModelNode update : updates) {
            try {
                AbstractSecurityDomainSetup.applyUpdate(client, update, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static void applyUpdate(ModelControllerClient client, ModelNode update, boolean allowFailure) throws Exception {
        ModelNode result = client.execute(new OperationBuilder(update).build());
        if (result.hasDefined("outcome") && (allowFailure || "success".equals(result.get("outcome").asString()))) {
            if (result.hasDefined("result")) {
                System.out.println(result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", this.getSecurityDomainName());
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
        try {
            AbstractSecurityDomainSetup.applyUpdate(managementClient.getControllerClient(), op, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getSecurityDomainName();

    protected void createSecurityDomain(Class loginModuleClass, Map<String, String> moduleOptionsCache, ModelControllerClient client) {
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "security").append("security-domain", this.getSecurityDomainName());
        steps.add(Util.createAddOperation((PathAddress)address));
        address = address.append("authentication", "classic");
        steps.add(Util.createAddOperation((PathAddress)address));
        ModelNode loginModule = Util.createAddOperation((PathAddress)address.append("login-module", loginModuleClass.getName()));
        loginModule.get("code").set(loginModuleClass.getName());
        loginModule.get("flag").set("required");
        loginModule.get("operation-headers").get("allow-resource-service-restart").set(true);
        ModelNode moduleOptions = loginModule.get("module-options");
        for (Map.Entry<String, String> entry : moduleOptionsCache.entrySet()) {
            moduleOptions.get(entry.getKey()).set(entry.getValue());
        }
        steps.add(loginModule);
        try {
            AbstractSecurityDomainSetup.applyUpdates(client, Arrays.asList(compositeOp));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

