/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang.SystemUtils;

public class Krb5LoginConfiguration
extends Configuration {
    private final AppConfigurationEntry[] configList = new AppConfigurationEntry[1];

    public Krb5LoginConfiguration() throws MalformedURLException {
        this(null, null, false);
    }

    public Krb5LoginConfiguration(String principal, File keyTab, boolean acceptor) throws MalformedURLException {
        String loginModule = Krb5LoginConfiguration.getLoginModule();
        Map<String, String> options = Krb5LoginConfiguration.getOptions(principal, keyTab, acceptor);
        this.configList[0] = new AppConfigurationEntry(loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    public static Map<String, String> getOptions() {
        return Krb5LoginConfiguration.getOptions(null, null, false);
    }

    public static Map<String, String> getOptions(String principal, File keyTab, boolean acceptor) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (SystemUtils.JAVA_VENDOR.startsWith("IBM")) {
            if (keyTab != null) {
                res.put("useKeytab", keyTab.toURI().toString());
            }
            if (acceptor) {
                res.put("credsType", "acceptor");
            } else {
                res.put("noAddress", "true");
            }
        } else {
            if (keyTab != null) {
                res.put("keyTab", keyTab.getAbsolutePath());
                res.put("doNotPrompt", "true");
                res.put("useKeyTab", "true");
            }
            if (acceptor) {
                res.put("storeKey", "true");
            }
        }
        res.put("refreshKrb5Config", "true");
        res.put("debug", "true");
        if (principal != null) {
            res.put("principal", principal);
        }
        return res;
    }

    public static String getLoginModule() {
        if (SystemUtils.JAVA_VENDOR.startsWith("IBM")) {
            return "com.ibm.security.auth.module.Krb5LoginModule";
        }
        return "com.sun.security.auth.module.Krb5LoginModule";
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        return this.configList;
    }
}

