/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.http.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.params.HttpParams;

public class HttpClientUtils {
    public static HttpClient wrapHttpsClient(HttpClient base) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
            return new DefaultHttpClient(ccm, base.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static DefaultHttpClient relaxedCookieHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register("best-match", new CookieSpecFactory(){

            public CookieSpec newInstance(HttpParams params) {
                return new RelaxedBrowserCompatSpec();
            }
        });
        client.setCookieSpecs(registry);
        return client;
    }

    public static class RelaxedBrowserCompatSpec
    extends BrowserCompatSpec {
        public RelaxedBrowserCompatSpec() {
            this.registerAttribHandler("domain", (CookieAttributeHandler)new BasicDomainHandler(){

                public boolean match(Cookie cookie, CookieOrigin origin) {
                    return true;
                }
            });
        }
    }
}

