package org.jboss.as.txn.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import javax.transaction.Synchronization;
import java.lang.Exception;
import javax.transaction.xa.Xid;
import java.lang.RuntimeException;
import javax.transaction.Transaction;
import org.jboss.as.controller.PathElement;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import javax.resource.spi.work.Work;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Object;
import java.util.Arrays;
import javax.xml.stream.Location;
import javax.resource.spi.work.WorkCompletedException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-30T14:53:38-0800")
public class TransactionLogger_$logger extends DelegatingBasicLogger implements TransactionLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TransactionLogger_$logger.class.getName();
    public TransactionLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToRollBack(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToRollBack$str());
    }
    private static final String unableToRollBack = "WFLYTX0001: Unable to roll back active transaction";
    protected String unableToRollBack$str() {
        return unableToRollBack;
    }
    @Override
    public final void unableToGetTransactionStatus(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToGetTransactionStatus$str());
    }
    private static final String unableToGetTransactionStatus = "WFLYTX0002: Unable to get transaction state";
    protected String unableToGetTransactionStatus$str() {
        return unableToGetTransactionStatus;
    }
    @Override
    public final void transactionStillOpen(final int status) {
        super.log.logf(FQCN, ERROR, null, transactionStillOpen$str(), status);
    }
    private static final String transactionStillOpen = "WFLYTX0003: APPLICATION ERROR: transaction still active in request with status %s";
    protected String transactionStillOpen$str() {
        return transactionStillOpen;
    }
    private static final String createFailed = "WFLYTX0004: Create failed";
    protected String createFailed$str() {
        return createFailed;
    }
    @Override
    public final StartException createFailed(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), createFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managerStartFailure = "WFLYTX0005: %s manager create failed";
    protected String managerStartFailure$str() {
        return managerStartFailure;
    }
    @Override
    public final StartException managerStartFailure(final Throwable cause, final String managerName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), managerStartFailure$str(), managerName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String objectStoreStartFailure = "WFLYTX0006: Failed to configure object store browser bean";
    protected String objectStoreStartFailure$str() {
        return objectStoreStartFailure;
    }
    @Override
    public final StartException objectStoreStartFailure(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), objectStoreStartFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceNotStarted = "WFLYTX0007: Service not started";
    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }
    @Override
    public final IllegalStateException serviceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String startFailure = "WFLYTX0008: Start failed";
    protected String startFailure$str() {
        return startFailure;
    }
    @Override
    public final StartException startFailure(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), startFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMetric = "WFLYTX0009: Unknown metric %s";
    protected String unknownMetric$str() {
        return unknownMetric;
    }
    @Override
    public final String unknownMetric(final Object metric) {
        return String.format(getLoggingLocale(), unknownMetric$str(), metric);
    }
    private static final String jmxSubsystemNotInstalled = "WFLYTX0010: MBean Server service not installed, this functionality is not available if the JMX subsystem has not been installed.";
    protected String jmxSubsystemNotInstalled$str() {
        return jmxSubsystemNotInstalled;
    }
    @Override
    public final RuntimeException jmxSubsystemNotInstalled() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), jmxSubsystemNotInstalled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentStatisticsSettings = "WFLYTX0012: Attributes %s and %s are alternatives; both cannot be set with conflicting values.";
    protected String inconsistentStatisticsSettings$str() {
        return inconsistentStatisticsSettings;
    }
    @Override
    public final OperationFailedException inconsistentStatisticsSettings(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void nodeIdentifierIsSetToDefault(final String attributeName, final String subsystemAddress) {
        super.log.logf(FQCN, WARN, null, nodeIdentifierIsSetToDefault$str(), attributeName, subsystemAddress);
    }
    private static final String nodeIdentifierIsSetToDefault = "WFLYTX0013: The %s attribute on the %s is set to the default value. This is a danger for environments running multiple servers. Please make sure the attribute value is unique.";
    protected String nodeIdentifierIsSetToDefault$str() {
        return nodeIdentifierIsSetToDefault;
    }
    private static final String jndiNameInvalidFormat = "WFLYTX0015: Jndi names have to start with java:/ or java:jboss/";
    protected String jndiNameInvalidFormat$str() {
        return jndiNameInvalidFormat;
    }
    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameInvalidFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rollbackOfTransactionStartedInEEConcurrentInvocation() {
        super.log.logf(FQCN, WARN, null, rollbackOfTransactionStartedInEEConcurrentInvocation$str());
    }
    private static final String rollbackOfTransactionStartedInEEConcurrentInvocation = "WFLYTX0016: Transaction started in EE Concurrent invocation left open, starting rollback to prevent leak.";
    protected String rollbackOfTransactionStartedInEEConcurrentInvocation$str() {
        return rollbackOfTransactionStartedInEEConcurrentInvocation;
    }
    @Override
    public final void failedToRollbackTransaction(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToRollbackTransaction$str());
    }
    private static final String failedToRollbackTransaction = "WFLYTX0017: Failed to rollback transaction.";
    protected String failedToRollbackTransaction$str() {
        return failedToRollbackTransaction;
    }
    @Override
    public final void failedToSuspendTransaction(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToSuspendTransaction$str());
    }
    private static final String failedToSuspendTransaction = "WFLYTX0018: Failed to suspend transaction.";
    protected String failedToSuspendTransaction$str() {
        return failedToSuspendTransaction;
    }
    @Override
    public final void systemErrorWhileCheckingForTransactionLeak(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, systemErrorWhileCheckingForTransactionLeak$str());
    }
    private static final String systemErrorWhileCheckingForTransactionLeak = "WFLYTX0019: System error while checking for transaction leak in EE Concurrent invocation.";
    protected String systemErrorWhileCheckingForTransactionLeak$str() {
        return systemErrorWhileCheckingForTransactionLeak;
    }
    private static final String serializationMustBeHandledByTheFactory = "WFLYTX0020: EE Concurrent ContextHandle serialization must be handled by the factory.";
    protected String serializationMustBeHandledByTheFactory$str() {
        return serializationMustBeHandledByTheFactory;
    }
    @Override
    public final IOException serializationMustBeHandledByTheFactory() {
        final IOException result = new IOException(String.format(getLoggingLocale(), serializationMustBeHandledByTheFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionSetupProviderServiceNotStarted = "WFLYTX0021: EE Concurrent's TransactionSetupProviderService not started.";
    protected String transactionSetupProviderServiceNotStarted$str() {
        return transactionSetupProviderServiceNotStarted;
    }
    @Override
    public final IllegalStateException transactionSetupProviderServiceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), transactionSetupProviderServiceNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustBeUndefinedIfTrue = "WFLYTX0023: %s must be undefined if %s is 'true'.";
    protected String mustBeUndefinedIfTrue$str() {
        return mustBeUndefinedIfTrue;
    }
    @Override
    public final OperationFailedException mustBeUndefinedIfTrue(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), mustBeUndefinedIfTrue$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustBedefinedIfDefined = "WFLYTX0024: %s must be defined if %s is defined.";
    protected String mustBedefinedIfDefined$str() {
        return mustBedefinedIfDefined;
    }
    @Override
    public final OperationFailedException mustBedefinedIfDefined(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), mustBedefinedIfDefined$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String eitherTrueOrDefined = "WFLYTX0025: Either %s must be 'true' or  %s must be defined.";
    protected String eitherTrueOrDefined$str() {
        return eitherTrueOrDefined;
    }
    @Override
    public final OperationFailedException eitherTrueOrDefined(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), eitherTrueOrDefined$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void transactionNotFound(final Transaction tx) {
        super.log.logf(FQCN, WARN, null, transactionNotFound$str(), tx);
    }
    private static final String transactionNotFound = "WFLYTX0026: The transaction %s could not be removed from the cache during cleanup.";
    protected String transactionNotFound$str() {
        return transactionNotFound;
    }
    @Override
    public final void preJcaSyncAfterCompletionFailed(final Synchronization preJcaSync, final Transaction tx, final Exception e) {
        super.log.logf(FQCN, WARN, e, preJcaSyncAfterCompletionFailed$str(), preJcaSync, tx);
    }
    private static final String preJcaSyncAfterCompletionFailed = "WFLYTX0027: The pre-jca synchronization %s associated with tx %s failed during after completion";
    protected String preJcaSyncAfterCompletionFailed$str() {
        return preJcaSyncAfterCompletionFailed;
    }
    @Override
    public final void jcaSyncAfterCompletionFailed(final Synchronization jcaSync, final Transaction tx, final Exception e) {
        super.log.logf(FQCN, WARN, e, jcaSyncAfterCompletionFailed$str(), jcaSync, tx);
    }
    private static final String jcaSyncAfterCompletionFailed = "WFLYTX0028: The jca synchronization %s associated with tx %s failed during after completion";
    protected String jcaSyncAfterCompletionFailed$str() {
        return jcaSyncAfterCompletionFailed;
    }
    private static final String syncsnotallowed = "WFLYTX0029: Syncs are not allowed to be registered when the tx is in state %s";
    protected String syncsnotallowed$str() {
        return syncsnotallowed;
    }
    @Override
    public final IllegalStateException syncsnotallowed(final int status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), syncsnotallowed$str(), status));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYTX0030: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttribute = "WFLYTX0031: The attribute '%s' is no longer supported";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final XMLStreamException unsupportedAttribute(final String attribute, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unsupportedAttribute$str(), attribute), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustBeDefinedIfTrue = "WFLYTX0032: %s must be defined if %s is 'true'.";
    protected String mustBeDefinedIfTrue$str() {
        return mustBeDefinedIfTrue;
    }
    @Override
    public final OperationFailedException mustBeDefinedIfTrue(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), mustBeDefinedIfTrue$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneCanBeTrue = "WFLYTX0033: Only one of %s and %s can be 'true'.";
    protected String onlyOneCanBeTrue$str() {
        return onlyOneCanBeTrue;
    }
    @Override
    public final OperationFailedException onlyOneCanBeTrue(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), onlyOneCanBeTrue$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void objectStoreRelativeToIsSetToDefault() {
        super.log.logf(FQCN, DEBUG, null, objectStoreRelativeToIsSetToDefault$str());
    }
    private static final String objectStoreRelativeToIsSetToDefault = "WFLYTX0034: relative_to property of the object-store is set to the default value with jboss.server.data.dir";
    protected String objectStoreRelativeToIsSetToDefault$str() {
        return objectStoreRelativeToIsSetToDefault;
    }
    private static final String cannotFindOrImportInflowTransaction = "WFLYTX0035: Cannot find or import inflow transaction for xid %s and work %s";
    protected String cannotFindOrImportInflowTransaction$str() {
        return cannotFindOrImportInflowTransaction;
    }
    @Override
    public final WorkCompletedException cannotFindOrImportInflowTransaction(final Xid xid, final Work work, final Exception e) {
        final WorkCompletedException result = new WorkCompletedException(String.format(getLoggingLocale(), cannotFindOrImportInflowTransaction$str(), xid, work), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String importedInflowTransactionIsInactive = "WFLYTX0036: Imported jca inflow transaction with xid %s of work %s is inactive";
    protected String importedInflowTransactionIsInactive$str() {
        return importedInflowTransactionIsInactive;
    }
    @Override
    public final WorkCompletedException importedInflowTransactionIsInactive(final Xid xid, final Work work, final Exception e) {
        final WorkCompletedException result = new WorkCompletedException(String.format(getLoggingLocale(), importedInflowTransactionIsInactive$str(), xid, work), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResumeInflowTransactionUnexpectedError = "WFLYTX0037: Unexpected error on resuming transaction %s for work %s";
    protected String cannotResumeInflowTransactionUnexpectedError$str() {
        return cannotResumeInflowTransactionUnexpectedError;
    }
    @Override
    public final WorkCompletedException cannotResumeInflowTransactionUnexpectedError(final Transaction txn, final Work work, final Exception e) {
        final WorkCompletedException result = new WorkCompletedException(String.format(getLoggingLocale(), cannotResumeInflowTransactionUnexpectedError$str(), txn, work), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSuspendInflowTransactionUnexpectedError = "WFLYTX0038: Unexpected error on suspending transaction for work %s";
    protected String cannotSuspendInflowTransactionUnexpectedError$str() {
        return cannotSuspendInflowTransactionUnexpectedError;
    }
    @Override
    public final RuntimeException cannotSuspendInflowTransactionUnexpectedError(final Work txn, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotSuspendInflowTransactionUnexpectedError$str(), txn), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void timeoutValueIsSetToMaximum(final int maximum_timeout) {
        super.log.logf(FQCN, WARN, null, timeoutValueIsSetToMaximum$str(), maximum_timeout);
    }
    private static final String timeoutValueIsSetToMaximum = "WFLYTX0039: A value of zero is not permitted for the maximum timeout, as such the timeout has been set to %s";
    protected String timeoutValueIsSetToMaximum$str() {
        return timeoutValueIsSetToMaximum;
    }
}
