/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.servlet.websockets.WebSocketServlet;
import io.undertow.websockets.WebSocketConnectionCallback;
import java.util.ArrayList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class UndertowNativeWebSocketDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        JBossWebMetaData mergedMetaData = metaData.getMergedJBossWebMetaData();
        if (!mergedMetaData.isEnableWebSockets()) {
            return;
        }
        if (mergedMetaData.getServlets() != null) {
            for (JBossServletMetaData servlet : mergedMetaData.getServlets()) {
                if (servlet.getServletClass() == null) continue;
                try {
                    Class clazz = classIndex.classIndex(servlet.getServletClass()).getModuleClass();
                    if (!WebSocketConnectionCallback.class.isAssignableFrom(clazz)) continue;
                    servlet.setServletClass(WebSocketServlet.class.getName());
                    if (servlet.getInitParam() == null) {
                        servlet.setInitParam(new ArrayList());
                    }
                    ParamValueMetaData param = new ParamValueMetaData();
                    param.setParamName("io.undertow.handler");
                    param.setParamValue(clazz.getName());
                    servlet.getInitParam().add(param);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException((Throwable)e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

