/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.SSLHeaderHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class HttpListenerService
extends ListenerService<HttpListenerService> {
    private volatile AcceptingChannel<StreamConnection> server;
    private final ChannelUpgradeHandler httpUpgradeHandler = new ChannelUpgradeHandler();
    protected final InjectedValue<ListenerRegistry> httpListenerRegistry = new InjectedValue();
    static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    static final String PROTOCOL = "http";
    private final String serverName;

    public HttpListenerService(String name, String serverName, OptionMap listenerOptions, OptionMap socketOptions, boolean certificateForwarding, boolean proxyAddressForwarding) {
        super(name, listenerOptions, socketOptions);
        this.serverName = serverName;
        this.addWrapperHandler(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                HttpListenerService.this.httpUpgradeHandler.setNonUpgradeHandler(handler);
                return HttpListenerService.this.httpUpgradeHandler;
            }
        });
        if (listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            this.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new Http2UpgradeHandler(handler);
                }
            });
        }
        if (certificateForwarding) {
            this.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new SSLHeaderHandler(handler);
                }
            });
        }
        if (proxyAddressForwarding) {
            this.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new ProxyPeerAddressHandler(handler);
                }
            });
        }
    }

    @Override
    protected OpenListener createOpenListener() {
        return new HttpOpenListener((Pool)this.getBufferPool().getValue(), OptionMap.builder().addAll(commonOptions).addAll(this.listenerOptions).set(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, this.getUndertowService().isStatisticsEnabled()).getMap());
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    protected void preStart(StartContext context) {
        context.getChildTarget().addService(HTTP_UPGRADE_REGISTRY.append(new String[]{this.getName()}), (Service)new ValueService((Value)new ImmediateValue((Object)this.httpUpgradeHandler))).install();
        ListenerRegistry.Listener listener = new ListenerRegistry.Listener(this.getProtocol(), this.getName(), this.serverName, ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
        listener.setContextInformation("socket-binding", this.getBinding().getValue());
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).addListener(listener);
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        this.server = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, OptionMap.builder().addAll(commonOptions).addAll(this.socketOptions).getMap());
        this.server.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTP", this.getName(), socketAddress);
    }

    @Override
    protected void cleanFailedStart() {
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).removeListener(this.getName());
    }

    @Override
    protected void stopListening() {
        this.server.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTP", this.getName());
        IoUtils.safeClose(this.server);
        this.server = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTP", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).removeListener(this.getName());
    }

    public HttpListenerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ListenerRegistry> getHttpListenerRegistry() {
        return this.httpListenerRegistry;
    }

    @Override
    protected String getProtocol() {
        return PROTOCOL;
    }
}

