/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.web.host.WebHost;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.HostAdd;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;

class HostRemove
extends AbstractRemoveStepHandler {
    HostRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parent = address.getParent();
        String name = address.getLastElement().getValue();
        String serverName = parent.getLastElement().getValue();
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, name);
        context.removeService(virtualHostServiceName);
        ServiceName consoleRedirectName = UndertowService.consoleRedirectServiceName(serverName, name);
        context.removeService(consoleRedirectName);
        ServiceName commonHostName = WebHost.SERVICE_NAME.append(new String[]{name});
        context.removeService(commonHostName);
        String defaultWebModule = HostDefinition.DEFAULT_WEB_MODULE.resolveModelAttribute(context, model).asString();
        DefaultDeploymentMappingProvider.instance().removeMapping(defaultWebModule);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            HostAdd.INSTANCE.performRuntime(context, operation, model);
        } else {
            context.revertReloadRequired();
        }
    }
}

