/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.impl.InMemorySingleSignOnManager;
import io.undertow.security.impl.SingleSignOnManager;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.security.sso.DistributableHostSingleSignOnManagerBuilder;

class HostSingleSignOnServiceHandler
implements ResourceServiceHandler {
    HostSingleSignOnServiceHandler() {
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String hostName = hostAddress.getLastElement().getValue();
        String serverName = serverAddress.getLastElement().getValue();
        String domain = ModelNodes.optionalString((ModelNode)SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, model)).orElse(null);
        String path = SingleSignOnDefinition.Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, model).asString();
        boolean secure = SingleSignOnDefinition.Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        boolean httpOnly = SingleSignOnDefinition.Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        String cookieName = SingleSignOnDefinition.Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, hostName);
        ServiceTarget target = context.getServiceTarget();
        ServiceName managerServiceName = serviceName.append(new String[]{"manager"});
        if (DistributableHostSingleSignOnManagerBuilder.INSTANCE.isPresent()) {
            DistributableHostSingleSignOnManagerBuilder builder = DistributableHostSingleSignOnManagerBuilder.INSTANCE.get();
            builder.build(target, managerServiceName, context.getCapabilityServiceSupport(), serverName, hostName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            target.addService(managerServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)new InMemorySingleSignOnManager()))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        SingleSignOnService service = new SingleSignOnService(domain, path, httpOnly, secure, cookieName);
        target.addService(serviceName, (Service)service).addDependency(virtualHostServiceName, Host.class, service.getHost()).addDependency(managerServiceName, SingleSignOnManager.class, service.getSingleSignOnSessionManager()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String hostName = hostAddress.getLastElement().getValue();
        String serverName = serverAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        context.removeService(serviceName);
        context.removeService(serviceName.append(new String[]{"manager"}));
    }
}

