/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.Handlers;
import io.undertow.jsp.JspFileHandler;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.predicate.Predicate;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContextFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MetricsCollector;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.deploy.JspPropertyGroup;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.authorization.modules.JACCAuthorizationModule;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.AuthMethodParser;
import org.wildfly.extension.undertow.deployment.DelegatingResourceManager;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.deployment.JspConfigDescriptorImpl;
import org.wildfly.extension.undertow.deployment.JspInitializationListener;
import org.wildfly.extension.undertow.deployment.LogoutSessionListener;
import org.wildfly.extension.undertow.deployment.RewriteCorrectingHandlerWrappers;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.ServletResourceManager;
import org.wildfly.extension.undertow.deployment.UndertowJSPInstanceManager;
import org.wildfly.extension.undertow.deployment.UndertowMetricsCollector;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.AuditNotificationReceiver;
import org.wildfly.extension.undertow.security.JAASIdentityManagerImpl;
import org.wildfly.extension.undertow.security.JbossAuthorizationManager;
import org.wildfly.extension.undertow.security.LogoutNotificationReceiver;
import org.wildfly.extension.undertow.security.RunAsLifecycleInterceptor;
import org.wildfly.extension.undertow.security.SecurityContextAssociationHandler;
import org.wildfly.extension.undertow.security.SecurityContextThreadSetupAction;
import org.wildfly.extension.undertow.security.jacc.JACCAuthorizationManager;
import org.wildfly.extension.undertow.security.jacc.JACCContextIdHandler;
import org.wildfly.extension.undertow.security.jaspi.JASPICAuthenticationMechanism;
import org.wildfly.extension.undertow.security.jaspi.JASPICSecureResponseHandler;
import org.wildfly.extension.undertow.security.jaspi.JASPICSecurityContextFactory;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class UndertowDeploymentInfoService
implements Service<DeploymentInfo> {
    private static final boolean JAVA_EE_8 = Boolean.getBoolean("ee8.preview.mode");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"UndertowDeploymentInfoService"});
    public static final String DEFAULT_SERVLET_NAME = "default";
    public static final String UNDERTOW = "undertow";
    private DeploymentInfo deploymentInfo;
    private ApplicationSecurityDomainDefinition.Registration registration;
    private final JBossWebMetaData mergedMetaData;
    private final String deploymentName;
    private final Module module;
    private final HashMap<String, TagLibraryInfo> tldInfo;
    private final ScisMetaData scisMetaData;
    private final VirtualFile deploymentRoot;
    private final String jaccContextId;
    private final String securityDomain;
    private final List<ServletContextAttribute> attributes;
    private final String contextPath;
    private final List<SetupAction> setupActions;
    private final Set<VirtualFile> overlays;
    private final List<ExpressionFactoryWrapper> expressionFactoryWrappers;
    private final List<PredicatedHandler> predicatedHandlers;
    private final List<HandlerWrapper> initialHandlerChainWrappers;
    private final List<HandlerWrapper> innerHandlerChainWrappers;
    private final List<HandlerWrapper> outerHandlerChainWrappers;
    private final List<ThreadSetupHandler> threadSetupActions;
    private final List<ServletExtension> servletExtensions;
    private final SharedSessionManagerConfig sharedSessionManagerConfig;
    private final boolean explodedDeployment;
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final InjectedValue<SessionManagerFactory> sessionManagerFactory = new InjectedValue();
    private final InjectedValue<SessionIdentifierCodec> sessionIdentifierCodec = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final InjectedValue<ComponentRegistry> componentRegistryInjectedValue = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<ControlPoint> controlPointInjectedValue = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentInjectedValue = new InjectedValue();
    private final Map<String, InjectedValue<Executor>> executorsByName = new HashMap<String, InjectedValue<Executor>>();
    private final WebSocketDeploymentInfo webSocketDeploymentInfo;
    private final File tempDir;
    private final List<File> externalResources;
    private final InjectedValue<BiFunction> securityFunction = new InjectedValue();
    private final List<Predicate> allowSuspendedRequests;

    private UndertowDeploymentInfoService(JBossWebMetaData mergedMetaData, String deploymentName, HashMap<String, TagLibraryInfo> tldInfo, Module module, ScisMetaData scisMetaData, VirtualFile deploymentRoot, String jaccContextId, String securityDomain, List<ServletContextAttribute> attributes, String contextPath, List<SetupAction> setupActions, Set<VirtualFile> overlays, List<ExpressionFactoryWrapper> expressionFactoryWrappers, List<PredicatedHandler> predicatedHandlers, List<HandlerWrapper> initialHandlerChainWrappers, List<HandlerWrapper> innerHandlerChainWrappers, List<HandlerWrapper> outerHandlerChainWrappers, List<ThreadSetupHandler> threadSetupActions, boolean explodedDeployment, List<ServletExtension> servletExtensions, SharedSessionManagerConfig sharedSessionManagerConfig, WebSocketDeploymentInfo webSocketDeploymentInfo, File tempDir, List<File> externalResources, List<Predicate> allowSuspendedRequests) {
        this.mergedMetaData = mergedMetaData;
        this.deploymentName = deploymentName;
        this.tldInfo = tldInfo;
        this.module = module;
        this.scisMetaData = scisMetaData;
        this.deploymentRoot = deploymentRoot;
        this.jaccContextId = jaccContextId;
        this.securityDomain = securityDomain;
        this.attributes = attributes;
        this.contextPath = contextPath;
        this.setupActions = setupActions;
        this.overlays = overlays;
        this.expressionFactoryWrappers = expressionFactoryWrappers;
        this.predicatedHandlers = predicatedHandlers;
        this.initialHandlerChainWrappers = initialHandlerChainWrappers;
        this.innerHandlerChainWrappers = innerHandlerChainWrappers;
        this.outerHandlerChainWrappers = outerHandlerChainWrappers;
        this.threadSetupActions = threadSetupActions;
        this.explodedDeployment = explodedDeployment;
        this.servletExtensions = servletExtensions;
        this.sharedSessionManagerConfig = sharedSessionManagerConfig;
        this.webSocketDeploymentInfo = webSocketDeploymentInfo;
        this.tempDir = tempDir;
        this.externalResources = externalResources;
        this.allowSuspendedRequests = allowSuspendedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            ControlPoint controlPoint;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.module.getClassLoader());
            DeploymentInfo deploymentInfo = this.createServletConfig();
            deploymentInfo.setConfidentialPortManager(this.getConfidentialPortManager());
            if (!JAVA_EE_8) {
                deploymentInfo.setContainerMinorVersion(1);
                deploymentInfo.setContainerMajorVersion(3);
            }
            this.handleDistributable(deploymentInfo);
            if (this.securityFunction.getOptionalValue() == null) {
                this.handleIdentityManager(deploymentInfo);
                this.handleJASPIMechanism(deploymentInfo);
                this.handleJACCAuthorization(deploymentInfo);
                this.handleAuthManagerLogout(deploymentInfo, this.mergedMetaData);
                if (this.mergedMetaData.isUseJBossAuthorization()) {
                    deploymentInfo.setAuthorizationManager((AuthorizationManager)new JbossAuthorizationManager(deploymentInfo.getAuthorizationManager()));
                }
            }
            this.handleAdditionalAuthenticationMechanisms(deploymentInfo);
            SessionConfigMetaData sessionConfig = this.mergedMetaData.getSessionConfig();
            if (this.sharedSessionManagerConfig != null && this.sharedSessionManagerConfig.getSessionConfig() != null) {
                sessionConfig = this.sharedSessionManagerConfig.getSessionConfig();
            }
            ServletSessionConfig config = null;
            SessionCookieConfig defaultSessionConfig = ((ServletContainerService)this.container.getValue()).getSessionCookieConfig();
            if (defaultSessionConfig != null) {
                config = new ServletSessionConfig();
                if (defaultSessionConfig.getName() != null) {
                    config.setName(defaultSessionConfig.getName());
                }
                if (defaultSessionConfig.getDomain() != null) {
                    config.setDomain(defaultSessionConfig.getDomain());
                }
                if (defaultSessionConfig.getHttpOnly() != null) {
                    config.setHttpOnly(defaultSessionConfig.getHttpOnly().booleanValue());
                }
                if (defaultSessionConfig.getSecure() != null) {
                    config.setSecure(defaultSessionConfig.getSecure().booleanValue());
                }
                if (defaultSessionConfig.getMaxAge() != null) {
                    config.setMaxAge(defaultSessionConfig.getMaxAge().intValue());
                }
                if (defaultSessionConfig.getComment() != null) {
                    config.setComment(defaultSessionConfig.getComment());
                }
            }
            SecureRandomSessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
            sessionIdGenerator.setLength(((ServletContainerService)this.container.getValue()).getSessionIdLength());
            deploymentInfo.setSessionIdGenerator((SessionIdGenerator)sessionIdGenerator);
            boolean sessionTimeoutSet = false;
            if (sessionConfig != null) {
                List modes;
                if (sessionConfig.getSessionTimeoutSet()) {
                    deploymentInfo.setDefaultSessionTimeout(sessionConfig.getSessionTimeout() * 60);
                    sessionTimeoutSet = true;
                }
                CookieConfigMetaData cookieConfig = sessionConfig.getCookieConfig();
                if (config == null) {
                    config = new ServletSessionConfig();
                }
                if (cookieConfig != null) {
                    if (cookieConfig.getName() != null) {
                        config.setName(cookieConfig.getName());
                    }
                    if (cookieConfig.getDomain() != null) {
                        config.setDomain(cookieConfig.getDomain());
                    }
                    if (cookieConfig.getComment() != null) {
                        config.setComment(cookieConfig.getComment());
                    }
                    config.setSecure(cookieConfig.getSecure());
                    config.setPath(cookieConfig.getPath());
                    config.setMaxAge(cookieConfig.getMaxAge());
                    config.setHttpOnly(cookieConfig.getHttpOnly());
                }
                if ((modes = sessionConfig.getSessionTrackingModes()) != null && !modes.isEmpty()) {
                    HashSet<SessionTrackingMode> trackingModes = new HashSet<SessionTrackingMode>();
                    for (SessionTrackingModeType mode : modes) {
                        switch (mode) {
                            case COOKIE: {
                                trackingModes.add(SessionTrackingMode.COOKIE);
                                break;
                            }
                            case SSL: {
                                trackingModes.add(SessionTrackingMode.SSL);
                                break;
                            }
                            case URL: {
                                trackingModes.add(SessionTrackingMode.URL);
                            }
                        }
                    }
                    config.setSessionTrackingModes(trackingModes);
                }
            }
            if (!sessionTimeoutSet) {
                deploymentInfo.setDefaultSessionTimeout(((ServletContainerService)this.container.getValue()).getDefaultSessionTimeout() * 60);
            }
            if (config != null) {
                deploymentInfo.setServletSessionConfig(config);
            }
            for (SetupAction action : this.setupActions) {
                deploymentInfo.addThreadSetupAction((ThreadSetupHandler)new UndertowThreadSetupAction(action));
            }
            if (this.initialHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.initialHandlerChainWrappers) {
                    deploymentInfo.addInitialHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.innerHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.innerHandlerChainWrappers) {
                    deploymentInfo.addInnerHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.outerHandlerChainWrappers != null) {
                for (HandlerWrapper handlerWrapper : this.outerHandlerChainWrappers) {
                    deploymentInfo.addOuterHandlerChainWrapper(handlerWrapper);
                }
            }
            if (this.threadSetupActions != null) {
                for (ThreadSetupHandler threadSetupAction : this.threadSetupActions) {
                    deploymentInfo.addThreadSetupAction(threadSetupAction);
                }
            }
            deploymentInfo.setServerName(((ServerEnvironment)this.serverEnvironmentInjectedValue.getValue()).getProductConfig().getPrettyVersionString());
            if (((UndertowService)this.undertowService.getValue()).isStatisticsEnabled()) {
                deploymentInfo.setMetricsCollector((MetricsCollector)new UndertowMetricsCollector());
            }
            if ((controlPoint = (ControlPoint)this.controlPointInjectedValue.getOptionalValue()) != null) {
                deploymentInfo.addOuterHandlerChainWrapper(GlobalRequestControllerHandler.wrapper(controlPoint, this.allowSuspendedRequests));
            }
            for (Map.Entry<String, AuthenticationMechanismFactory> e : ((ServletContainerService)this.container.getValue()).getAuthenticationMechanisms().entrySet()) {
                deploymentInfo.addAuthenticationMechanism(e.getKey(), e.getValue());
            }
            deploymentInfo.setUseCachedAuthenticationMechanism(!deploymentInfo.getAuthenticationMechanisms().containsKey("SSO"));
            this.deploymentInfo = deploymentInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    private void handleAuthManagerLogout(DeploymentInfo deploymentInfo, JBossWebMetaData mergedMetaData) {
        if (this.securityDomain == null) {
            return;
        }
        AuthenticationManager manager = ((SecurityDomainContext)this.securityDomainContextValue.getValue()).getAuthenticationManager();
        deploymentInfo.addNotificationReceiver((NotificationReceiver)new LogoutNotificationReceiver(manager, this.securityDomain));
        if (mergedMetaData.isFlushOnSessionInvalidation()) {
            LogoutSessionListener listener = new LogoutSessionListener(manager);
            deploymentInfo.addListener(Servlets.listener(LogoutSessionListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)));
        }
    }

    public synchronized void stop(StopContext stopContext) {
        AuthenticationManager authManager;
        IoUtils.safeClose((Closeable)this.deploymentInfo.getResourceManager());
        if (this.securityDomain != null && this.securityFunction.getOptionalValue() == null && (authManager = ((SecurityDomainContext)this.securityDomainContextValue.getValue()).getAuthenticationManager()) != null && authManager instanceof JBossCachedAuthenticationManager) {
            ((JBossCachedAuthenticationManager)authManager).releaseModuleEntries((ClassLoader)this.module.getClassLoader());
        }
        this.deploymentInfo.setConfidentialPortManager(null);
        this.deploymentInfo = null;
        if (this.registration != null) {
            this.registration.cancel();
        }
    }

    public synchronized DeploymentInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentInfo;
    }

    private void handleJASPIMechanism(DeploymentInfo deploymentInfo) {
        if (this.securityDomain == null) {
            return;
        }
        ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)this.securityDomain);
        if (applicationPolicy != null && JASPIAuthenticationInfo.class.isInstance(applicationPolicy.getAuthenticationInfo())) {
            String authMethod = null;
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            if (loginConfig != null && loginConfig.getAuthMethods().size() > 0) {
                authMethod = ((AuthMethodConfig)loginConfig.getAuthMethods().get(0)).getName();
            }
            deploymentInfo.setJaspiAuthenticationMechanism((AuthenticationMechanism)new JASPICAuthenticationMechanism(this.securityDomain, authMethod));
            deploymentInfo.setSecurityContextFactory((SecurityContextFactory)new JASPICSecurityContextFactory(this.securityDomain));
            deploymentInfo.addOuterHandlerChainWrapper(next -> new JASPICSecureResponseHandler(next));
        }
    }

    private void handleJACCAuthorization(DeploymentInfo deploymentInfo) {
        AuthorizationInfo authzInfo;
        if (this.securityDomain == null) {
            return;
        }
        ApplicationPolicy applicationPolicy = SecurityConfiguration.getApplicationPolicy((String)this.securityDomain);
        if (applicationPolicy != null && (authzInfo = applicationPolicy.getAuthorizationInfo()) != null) {
            for (AuthorizationModuleEntry entry : authzInfo.getModuleEntries()) {
                if (!JACCAuthorizationModule.class.getName().equals(entry.getPolicyModuleName())) continue;
                deploymentInfo.setAuthorizationManager((AuthorizationManager)new JACCAuthorizationManager());
                break;
            }
        }
    }

    private void handleAdditionalAuthenticationMechanisms(DeploymentInfo deploymentInfo) {
        for (Map.Entry<String, AuthenticationMechanism> am : ((Host)this.host.getValue()).getAdditionalAuthenticationMechanisms().entrySet()) {
            deploymentInfo.addFirstAuthenticationMechanism(am.getKey(), am.getValue());
        }
    }

    private void handleIdentityManager(DeploymentInfo deploymentInfo) {
        if (this.securityDomain != null) {
            SecurityDomainContext sdc = (SecurityDomainContext)this.securityDomainContextValue.getValue();
            deploymentInfo.setIdentityManager((IdentityManager)new JAASIdentityManagerImpl(sdc));
            AuditManager auditManager = sdc.getAuditManager();
            if (auditManager != null && !this.mergedMetaData.isDisableAudit()) {
                deploymentInfo.addNotificationReceiver((NotificationReceiver)new AuditNotificationReceiver(auditManager));
            }
        }
    }

    private ConfidentialPortManager getConfidentialPortManager() {
        return new ConfidentialPortManager(){

            public int getConfidentialPort(HttpServerExchange exchange) {
                int port = ((InetSocketAddress)exchange.getConnection().getLocalAddress(InetSocketAddress.class)).getPort();
                if (port < 0) {
                    UndertowLogger.ROOT_LOGGER.debugf("Confidential port not defined for port %s", port);
                }
                return ((Host)UndertowDeploymentInfoService.this.host.getValue()).getServer().getValue().lookupSecurePort(port);
            }
        };
    }

    private void handleDistributable(DeploymentInfo deploymentInfo) {
        SessionIdentifierCodec codec;
        SessionManagerFactory managerFactory = (SessionManagerFactory)this.sessionManagerFactory.getOptionalValue();
        if (managerFactory != null) {
            deploymentInfo.setSessionManagerFactory(managerFactory);
        }
        if ((codec = (SessionIdentifierCodec)this.sessionIdentifierCodec.getOptionalValue()) != null) {
            deploymentInfo.setSessionConfigWrapper((SessionConfigWrapper)new CodecSessionConfigWrapper(codec));
        }
    }

    private String resolveContextPath() {
        if (this.deploymentName.equals(((Host)this.host.getValue()).getDefaultWebModule())) {
            return "/";
        }
        return this.contextPath;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeploymentInfo createServletConfig() throws StartException {
        ComponentRegistry componentRegistry = (ComponentRegistry)this.componentRegistryInjectedValue.getValue();
        try {
            LoginConfigMetaData loginConfigMetaData;
            void var5_14;
            Boolean proactiveAuthentication;
            ServletInfo jspServlet;
            if (!this.mergedMetaData.isMetadataComplete()) {
                this.mergedMetaData.resolveAnnotations();
            }
            this.mergedMetaData.resolveRunAs();
            DeploymentInfo d = new DeploymentInfo();
            d.setContextPath(this.resolveContextPath());
            if (this.mergedMetaData.getDescriptionGroup() != null) {
                d.setDisplayName(this.mergedMetaData.getDescriptionGroup().getDisplayName());
            }
            d.setDeploymentName(this.deploymentName);
            d.setHostName(((Host)this.host.getValue()).getName());
            ServletContainerService servletContainer = (ServletContainerService)this.container.getValue();
            try {
                void var5_10;
                List externalOverlays = this.mergedMetaData.getOverlays();
                ServletResourceManager servletResourceManager = new ServletResourceManager(this.deploymentRoot, this.overlays, this.explodedDeployment, this.mergedMetaData.isSymbolicLinkingEnabled(), servletContainer.isDisableFileWatchService(), externalOverlays);
                CachingResourceManager cachingResourceManager = new CachingResourceManager(servletContainer.getFileCacheMetadataSize(), (long)servletContainer.getFileCacheMaxFileSize(), servletContainer.getBufferCache(), (ResourceManager)servletResourceManager, servletContainer.getFileCacheTimeToLive() == null ? (this.explodedDeployment ? 2000 : -1) : servletContainer.getFileCacheTimeToLive());
                if (this.externalResources != null && !this.externalResources.isEmpty()) {
                    ArrayList<ResourceManager> delegates = new ArrayList<ResourceManager>();
                    for (File resource : this.externalResources) {
                        delegates.add((ResourceManager)new FileResourceManager(resource.getCanonicalFile(), 1024L, true, this.mergedMetaData.isSymbolicLinkingEnabled(), new String[]{"/"}));
                    }
                    delegates.add((ResourceManager)cachingResourceManager);
                    DelegatingResourceManager delegatingResourceManager = new DelegatingResourceManager(delegates);
                }
                d.setResourceManager((ResourceManager)var5_10);
            }
            catch (IOException e) {
                throw new StartException((Throwable)e);
            }
            d.setTempDir(this.tempDir);
            d.setClassLoader((ClassLoader)this.module.getClassLoader());
            String servletVersion = this.mergedMetaData.getServletVersion();
            if (servletVersion != null) {
                d.setMajorVersion(Integer.parseInt(servletVersion.charAt(0) + ""));
                d.setMinorVersion(Integer.parseInt(servletVersion.charAt(2) + ""));
            } else {
                d.setMajorVersion(3);
                d.setMinorVersion(1);
            }
            d.setIgnoreFlush(servletContainer.isIgnoreFlush());
            d.setEagerFilterInit(servletContainer.isEagerFilterInit());
            d.setAllowNonStandardWrappers(servletContainer.isAllowNonStandardWrappers());
            d.setServletStackTraces(servletContainer.getStackTraces());
            d.setDisableCachingForSecuredPages(servletContainer.isDisableCachingForSecuredPages());
            if (servletContainer.isDisableSessionIdReuse()) {
                d.setCheckOtherSessionManagers(false);
            }
            if (servletContainer.getSessionPersistenceManager() != null) {
                d.setSessionPersistenceManager(servletContainer.getSessionPersistenceManager());
            }
            if (d.getMajorVersion() == 1) {
                boolean bl = true;
            } else if (d.getMajorVersion() == 2) {
                boolean bl = d.getMinorVersion() < 3;
            } else {
                boolean bl = false;
            }
            JSPConfig jspConfig = servletContainer.getJspConfig();
            HashSet<String> seenMappings = new HashSet<String>();
            ServletInfo servletInfo = jspServlet = jspConfig != null ? jspConfig.createJSPServletInfo() : null;
            if (jspServlet != null) {
                HashMap<String, JspPropertyGroup> propertyGroups = UndertowDeploymentInfoService.createJspConfig(this.mergedMetaData);
                JspServletBuilder.setupDeployment((DeploymentInfo)d, propertyGroups, this.tldInfo, (InstanceManager)new UndertowJSPInstanceManager(new WebInjectionContainer((ClassLoader)this.module.getClassLoader(), (ComponentRegistry)this.componentRegistryInjectedValue.getValue())));
                if (this.mergedMetaData.getJspConfig() != null) {
                    LinkedHashSet<JspPropertyGroup> values = new LinkedHashSet<JspPropertyGroup>(propertyGroups.values());
                    d.setJspConfigDescriptor((JspConfigDescriptor)new JspConfigDescriptorImpl(this.tldInfo.values(), values));
                }
                d.addServlet(jspServlet);
                Set<String> jspPropertyGroupMappings = propertyGroups.keySet();
                for (String string : jspPropertyGroupMappings) {
                    if (jspServlet.getMappings().contains(string)) continue;
                    jspServlet.addMapping(string);
                }
                seenMappings.addAll(jspPropertyGroupMappings);
                d.addListener(new ListenerInfo(JspInitializationListener.class));
                d.addServletContextAttribute("org.jboss.as.web.deployment.JspInitializationListener.wrappers", this.expressionFactoryWrappers);
            }
            d.setClassIntrospecter((ClassIntrospecter)new ComponentClassIntrospector(componentRegistry));
            HashMap<String, List<ServletMappingMetaData>> servletMappings = new HashMap<String, List<ServletMappingMetaData>>();
            if (this.mergedMetaData.getExecutorName() != null) {
                d.setExecutor((Executor)this.executorsByName.get(this.mergedMetaData.getExecutorName()).getValue());
            }
            if ((proactiveAuthentication = this.mergedMetaData.getProactiveAuthentication()) == null) {
                proactiveAuthentication = ((ServletContainerService)this.container.getValue()).isProactiveAuth();
            }
            d.setAuthenticationMode(proactiveAuthentication != false ? AuthenticationMode.PRO_ACTIVE : AuthenticationMode.CONSTRAINT_DRIVEN);
            if (this.servletExtensions != null) {
                for (ServletExtension servletExtension : this.servletExtensions) {
                    d.addServletExtension(servletExtension);
                }
            }
            if (this.mergedMetaData.getServletMappings() != null) {
                for (ServletMappingMetaData servletMappingMetaData : this.mergedMetaData.getServletMappings()) {
                    void var13_52;
                    List list = (List)servletMappings.get(servletMappingMetaData.getServletName());
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                        servletMappings.put(servletMappingMetaData.getServletName(), arrayList);
                    }
                    var13_52.add(servletMappingMetaData);
                }
            }
            if (jspServlet != null) {
                jspServlet.addHandlerChainWrapper(JspFileHandler.jspFileHandlerWrapper(null));
                List list = (List)servletMappings.get(jspServlet.getName());
                if (list != null && !list.isEmpty()) {
                    for (ServletMappingMetaData servletMappingMetaData : list) {
                        for (String urlPattern : servletMappingMetaData.getUrlPatterns()) {
                            jspServlet.addMapping(urlPattern);
                        }
                        seenMappings.addAll(servletMappingMetaData.getUrlPatterns());
                    }
                }
            }
            ArrayList<JBossServletMetaData> servlets = new ArrayList<JBossServletMetaData>();
            for (JBossServletMetaData jBossServletMetaData : this.mergedMetaData.getServlets()) {
                servlets.add(jBossServletMetaData);
            }
            for (JBossServletMetaData jBossServletMetaData : this.mergedMetaData.getServlets()) {
                void var14_89;
                if (jBossServletMetaData.getJspFile() != null) {
                    ServletInfo servletInfo2 = new ServletInfo(jBossServletMetaData.getName(), JspServlet.class);
                    servletInfo2.addHandlerChainWrapper(JspFileHandler.jspFileHandlerWrapper((String)jBossServletMetaData.getJspFile()));
                } else if (jBossServletMetaData.getServletClass() == null) {
                    if (!DEFAULT_SERVLET_NAME.equals(jBossServletMetaData.getName())) throw UndertowLogger.ROOT_LOGGER.servletClassNotDefined(jBossServletMetaData.getServletName());
                    ServletInfo servletInfo3 = new ServletInfo(jBossServletMetaData.getName(), DefaultServlet.class);
                } else {
                    Class servletClass = this.module.getClassLoader().loadClass(jBossServletMetaData.getServletClass());
                    ManagedReferenceFactory creator = componentRegistry.createInstanceFactory(servletClass);
                    if (creator != null) {
                        InstanceFactory instanceFactory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                        ServletInfo servletInfo4 = new ServletInfo(jBossServletMetaData.getName(), servletClass, instanceFactory);
                    } else {
                        ServletInfo servletInfo5 = new ServletInfo(jBossServletMetaData.getName(), servletClass);
                    }
                }
                var14_89.setAsyncSupported(jBossServletMetaData.isAsyncSupported()).setJspFile(jBossServletMetaData.getJspFile()).setEnabled(jBossServletMetaData.isEnabled());
                if (jBossServletMetaData.getRunAs() != null) {
                    var14_89.setRunAs(jBossServletMetaData.getRunAs().getRoleName());
                }
                if (jBossServletMetaData.getLoadOnStartupSet()) {
                    var14_89.setLoadOnStartup(Integer.valueOf(jBossServletMetaData.getLoadOnStartupInt()));
                }
                if (jBossServletMetaData.getExecutorName() != null) {
                    var14_89.setExecutor((Executor)this.executorsByName.get(jBossServletMetaData.getExecutorName()).getValue());
                }
                this.handleServletMappings((boolean)var5_14, seenMappings, servletMappings, (ServletInfo)var14_89);
                if (jBossServletMetaData.getInitParam() != null) {
                    for (Object initParam : jBossServletMetaData.getInitParam()) {
                        if (var14_89.getInitParams().containsKey(initParam.getParamName())) continue;
                        var14_89.addInitParam(initParam.getParamName(), initParam.getParamValue());
                    }
                }
                if (jBossServletMetaData.getServletSecurity() != null) {
                    ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                    var14_89.setServletSecurityInfo(securityInfo);
                    ((ServletSecurityInfo)((ServletSecurityInfo)securityInfo.setEmptyRoleSemantic(jBossServletMetaData.getServletSecurity().getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(jBossServletMetaData.getServletSecurity().getTransportGuarantee()))).addRolesAllowed((Collection)jBossServletMetaData.getServletSecurity().getRolesAllowed());
                    if (jBossServletMetaData.getServletSecurity().getHttpMethodConstraints() != null) {
                        Object initParam;
                        initParam = jBossServletMetaData.getServletSecurity().getHttpMethodConstraints().iterator();
                        while (initParam.hasNext()) {
                            HttpMethodConstraintMetaData httpMethodConstraintMetaData = (HttpMethodConstraintMetaData)initParam.next();
                            securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(httpMethodConstraintMetaData.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(httpMethodConstraintMetaData.getTransportGuarantee()))).addRolesAllowed((Collection)httpMethodConstraintMetaData.getRolesAllowed())).setMethod(httpMethodConstraintMetaData.getMethod()));
                        }
                    }
                }
                if (jBossServletMetaData.getSecurityRoleRefs() != null) {
                    for (SecurityRoleRefMetaData ref : jBossServletMetaData.getSecurityRoleRefs()) {
                        var14_89.addSecurityRoleRef(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                if (jBossServletMetaData.getMultipartConfig() != null) {
                    MultipartConfigMetaData mp = jBossServletMetaData.getMultipartConfig();
                    var14_89.setMultipartConfig(Servlets.multipartConfig((String)mp.getLocation(), (long)mp.getMaxFileSize(), (long)mp.getMaxRequestSize(), (int)mp.getFileSizeThreshold()));
                }
                d.addServlet((ServletInfo)var14_89);
            }
            if (jspServlet != null) {
                if (!seenMappings.contains("*.jsp")) {
                    jspServlet.addMapping("*.jsp");
                }
                if (!seenMappings.contains("*.jspx")) {
                    jspServlet.addMapping("*.jspx");
                }
            }
            if (!this.mergedMetaData.getServlets().containsKey(DEFAULT_SERVLET_NAME)) {
                ServletInfo servletInfo6 = Servlets.servlet((String)DEFAULT_SERVLET_NAME, DefaultServlet.class);
                this.handleServletMappings((boolean)var5_14, seenMappings, servletMappings, servletInfo6);
                d.addServlet(servletInfo6);
            }
            if (servletContainer.getDirectoryListingEnabled() != null) {
                ServletInfo servletInfo7 = (ServletInfo)d.getServlets().get(DEFAULT_SERVLET_NAME);
                servletInfo7.addInitParam("directory-listing", servletContainer.getDirectoryListingEnabled().toString());
            }
            if (this.mergedMetaData.getFilters() != null) {
                for (FilterMetaData filterMetaData : this.mergedMetaData.getFilters()) {
                    Object f;
                    Class clazz = this.module.getClassLoader().loadClass(filterMetaData.getFilterClass());
                    ManagedReferenceFactory creator = componentRegistry.createInstanceFactory(clazz);
                    if (creator != null) {
                        InstanceFactory instanceFactory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                        f = new FilterInfo(filterMetaData.getName(), clazz, instanceFactory);
                    } else {
                        f = new FilterInfo(filterMetaData.getName(), clazz);
                    }
                    f.setAsyncSupported(filterMetaData.isAsyncSupported());
                    d.addFilter((FilterInfo)f);
                    if (filterMetaData.getInitParam() == null) continue;
                    for (ParamValueMetaData initParam : filterMetaData.getInitParam()) {
                        f.addInitParam(initParam.getParamName(), initParam.getParamValue());
                    }
                }
            }
            if (this.mergedMetaData.getFilterMappings() != null) {
                for (FilterMappingMetaData filterMappingMetaData : this.mergedMetaData.getFilterMappings()) {
                    if (filterMappingMetaData.getUrlPatterns() != null) {
                        for (String url : filterMappingMetaData.getUrlPatterns()) {
                            if (var5_14 != false && !url.startsWith("*") && !url.startsWith("/")) {
                                url = "/" + url;
                            }
                            if (filterMappingMetaData.getDispatchers() != null && !filterMappingMetaData.getDispatchers().isEmpty()) {
                                for (DispatcherType dispatcherType : filterMappingMetaData.getDispatchers()) {
                                    d.addFilterUrlMapping(filterMappingMetaData.getFilterName(), url, javax.servlet.DispatcherType.valueOf((String)dispatcherType.name()));
                                }
                                continue;
                            }
                            d.addFilterUrlMapping(filterMappingMetaData.getFilterName(), url, javax.servlet.DispatcherType.REQUEST);
                        }
                    }
                    if (filterMappingMetaData.getServletNames() == null) continue;
                    for (String servletName : filterMappingMetaData.getServletNames()) {
                        if (filterMappingMetaData.getDispatchers() != null && !filterMappingMetaData.getDispatchers().isEmpty()) {
                            for (DispatcherType dispatcherType : filterMappingMetaData.getDispatchers()) {
                                d.addFilterServletNameMapping(filterMappingMetaData.getFilterName(), servletName, javax.servlet.DispatcherType.valueOf((String)dispatcherType.name()));
                            }
                            continue;
                        }
                        d.addFilterServletNameMapping(filterMappingMetaData.getFilterName(), servletName, javax.servlet.DispatcherType.REQUEST);
                    }
                }
            }
            if (this.scisMetaData != null && this.scisMetaData.getHandlesTypes() != null) {
                for (ServletContainerInitializer servletContainerInitializer : this.scisMetaData.getScis()) {
                    ImmediateInstanceFactory immediateInstanceFactory = new ImmediateInstanceFactory((Object)servletContainerInitializer);
                    d.addServletContainerInitalizer(new ServletContainerInitializerInfo(servletContainerInitializer.getClass(), (InstanceFactory)immediateInstanceFactory, this.scisMetaData.getHandlesTypes().get(servletContainerInitializer)));
                }
            }
            if (this.mergedMetaData.getListeners() != null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Map.Entry<String, TagLibraryInfo> entry : this.tldInfo.entrySet()) {
                    hashSet.addAll(Arrays.asList(entry.getValue().getListeners()));
                }
                for (ListenerMetaData listenerMetaData : this.mergedMetaData.getListeners()) {
                    UndertowDeploymentInfoService.addListener((ClassLoader)this.module.getClassLoader(), componentRegistry, d, listenerMetaData, hashSet.contains(listenerMetaData.getListenerClass()));
                }
            }
            if (this.mergedMetaData.getContextParams() != null) {
                for (ParamValueMetaData paramValueMetaData : this.mergedMetaData.getContextParams()) {
                    d.addInitParameter(paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
                }
            }
            if (this.mergedMetaData.getWelcomeFileList() != null && this.mergedMetaData.getWelcomeFileList().getWelcomeFiles() != null) {
                List list = this.mergedMetaData.getWelcomeFileList().getWelcomeFiles();
                for (String string : list) {
                    if (string.startsWith("/")) {
                        d.addWelcomePages(new String[]{string.substring(1)});
                        continue;
                    }
                    d.addWelcomePages(new String[]{string});
                }
            } else {
                d.addWelcomePages(new String[]{"index.html", "index.htm", "index.jsp"});
            }
            d.addWelcomePages(servletContainer.getWelcomeFiles());
            if (this.mergedMetaData.getErrorPages() != null) {
                for (ErrorPageMetaData errorPageMetaData : this.mergedMetaData.getErrorPages()) {
                    void var14_107;
                    if (errorPageMetaData.getExceptionType() != null && !errorPageMetaData.getExceptionType().isEmpty()) {
                        ErrorPage errorPage = new ErrorPage(errorPageMetaData.getLocation(), this.module.getClassLoader().loadClass(errorPageMetaData.getExceptionType()));
                    } else if (errorPageMetaData.getErrorCode() != null && !errorPageMetaData.getErrorCode().isEmpty()) {
                        ErrorPage errorPage = new ErrorPage(errorPageMetaData.getLocation(), Integer.parseInt(errorPageMetaData.getErrorCode()));
                    } else {
                        ErrorPage errorPage = new ErrorPage(errorPageMetaData.getLocation());
                    }
                    d.addErrorPages(new ErrorPage[]{var14_107});
                }
            }
            for (Map.Entry<String, String> entry : servletContainer.getMimeMappings().entrySet()) {
                d.addMimeMapping(new MimeMapping(entry.getKey(), entry.getValue()));
            }
            if (this.mergedMetaData.getMimeMappings() != null) {
                for (MimeMappingMetaData mimeMappingMetaData : this.mergedMetaData.getMimeMappings()) {
                    d.addMimeMapping(new MimeMapping(mimeMappingMetaData.getExtension(), mimeMappingMetaData.getMimeType()));
                }
            }
            d.setDenyUncoveredHttpMethods(this.mergedMetaData.getDenyUncoveredHttpMethods() != null);
            Set set = this.mergedMetaData.getSecurityRoleNames();
            if (this.mergedMetaData.getSecurityConstraints() != null) {
                for (SecurityConstraintMetaData securityConstraintMetaData : this.mergedMetaData.getSecurityConstraints()) {
                    SecurityConstraint securityConstraint = (SecurityConstraint)new SecurityConstraint().setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(securityConstraintMetaData.getTransportGuarantee()));
                    List roleNames = securityConstraintMetaData.getRoleNames();
                    if (securityConstraintMetaData.getAuthConstraint() == null) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                    } else if (roleNames.size() == 1 && roleNames.contains("*") && set.contains("*")) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                    } else {
                        securityConstraint.addRolesAllowed((Collection)roleNames);
                    }
                    if (securityConstraintMetaData.getResourceCollections() != null) {
                        for (WebResourceCollectionMetaData resourceCollection : securityConstraintMetaData.getResourceCollections()) {
                            securityConstraint.addWebResourceCollection(new WebResourceCollection().addHttpMethods((Collection)resourceCollection.getHttpMethods()).addHttpMethodOmissions((Collection)resourceCollection.getHttpMethodOmissions()).addUrlPatterns((Collection)resourceCollection.getUrlPatterns()));
                        }
                    }
                    d.addSecurityConstraint(securityConstraint);
                }
            }
            if ((loginConfigMetaData = this.mergedMetaData.getLoginConfig()) != null) {
                List<AuthMethodConfig> list = UndertowDeploymentInfoService.authMethod(loginConfigMetaData.getAuthMethod());
                if (loginConfigMetaData.getFormLoginConfig() != null) {
                    d.setLoginConfig(new LoginConfig(loginConfigMetaData.getRealmName(), loginConfigMetaData.getFormLoginConfig().getLoginPage(), loginConfigMetaData.getFormLoginConfig().getErrorPage()));
                } else {
                    d.setLoginConfig(new LoginConfig(loginConfigMetaData.getRealmName()));
                }
                for (AuthMethodConfig method : list) {
                    d.getLoginConfig().addLastAuthMethod(method);
                }
            }
            d.addSecurityRoles((Collection)this.mergedMetaData.getSecurityRoleNames());
            Map map = this.mergedMetaData.getPrincipalVersusRolesMap();
            BiFunction securityFunction = (BiFunction)this.securityFunction.getOptionalValue();
            if (securityFunction != null) {
                Iterator<ServletContextAttribute> runAsIdentityMap = this.mergedMetaData.getRunAsIdentity();
                this.registration = (ApplicationSecurityDomainDefinition.Registration)securityFunction.apply(d, ((Map)((Object)runAsIdentityMap))::get);
                d.addOuterHandlerChainWrapper(JACCContextIdHandler.wrapper(this.jaccContextId));
                if (this.mergedMetaData.isUseJBossAuthorization()) {
                    UndertowLogger.ROOT_LOGGER.configurationOptionIgnoredWhenUsingElytron("use-jboss-authorization");
                }
            } else if (this.securityDomain != null) {
                d.addThreadSetupAction((ThreadSetupHandler)new SecurityContextThreadSetupAction(this.securityDomain, (SecurityDomainContext)this.securityDomainContextValue.getValue(), map));
                d.addInnerHandlerChainWrapper(SecurityContextAssociationHandler.wrapper(this.mergedMetaData.getRunAsIdentity()));
                d.addOuterHandlerChainWrapper(JACCContextIdHandler.wrapper(this.jaccContextId));
                d.addLifecycleInterceptor((LifecycleInterceptor)new RunAsLifecycleInterceptor(this.mergedMetaData.getRunAsIdentity()));
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    d.addPrincipalVsRoleMappings((String)entry.getKey(), (Collection)entry.getValue());
                }
            }
            if (this.attributes != null) {
                for (ServletContextAttribute servletContextAttribute : this.attributes) {
                    d.addServletContextAttribute(servletContextAttribute.getName(), servletContextAttribute.getValue());
                }
            }
            if (servletContainer.isWebsocketsEnabled() && this.webSocketDeploymentInfo != null) {
                this.webSocketDeploymentInfo.setBuffers((Pool)servletContainer.getWebsocketsBufferPool().getValue());
                this.webSocketDeploymentInfo.setWorker((XnioWorker)servletContainer.getWebsocketsWorker().getValue());
                this.webSocketDeploymentInfo.setDispatchToWorkerThread(servletContainer.isDispatchWebsocketInvocationToWorker());
                if (servletContainer.isPerMessageDeflate()) {
                    PerMessageDeflateHandshake perMessageDeflate = new PerMessageDeflateHandshake(false, servletContainer.getDeflaterLevel());
                    this.webSocketDeploymentInfo.addExtension((ExtensionHandshake)perMessageDeflate);
                }
                final AtomicReference serverActivity = new AtomicReference();
                this.webSocketDeploymentInfo.addListener(wsc -> {
                    serverActivity.set(new ServerActivity(){

                        public void preSuspend(ServerActivityCallback listener) {
                            listener.done();
                        }

                        public void suspended(final ServerActivityCallback listener) {
                            if (wsc.getConfiguredServerEndpoints().isEmpty()) {
                                listener.done();
                                return;
                            }
                            wsc.pause(new ServerWebSocketContainer.PauseListener(){

                                public void paused() {
                                    listener.done();
                                }

                                public void resumed() {
                                }
                            });
                        }

                        public void resume() {
                            wsc.resume();
                        }
                    });
                    ((SuspendController)this.suspendControllerInjectedValue.getValue()).registerActivity((ServerActivity)serverActivity.get());
                });
                ServletContextListener servletContextListener = new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                    }

                    public void contextDestroyed(ServletContextEvent sce) {
                        ServerActivity activity = (ServerActivity)serverActivity.get();
                        if (activity != null) {
                            ((SuspendController)UndertowDeploymentInfoService.this.suspendControllerInjectedValue.getValue()).unRegisterActivity(activity);
                        }
                    }
                };
                d.addListener(new ListenerInfo(servletContextListener.getClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servletContextListener)));
                d.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)this.webSocketDeploymentInfo);
            }
            if (this.mergedMetaData.getLocalEncodings() != null && this.mergedMetaData.getLocalEncodings().getMappings() != null) {
                for (LocaleEncodingMetaData localeEncodingMetaData : this.mergedMetaData.getLocalEncodings().getMappings()) {
                    d.addLocaleCharsetMapping(localeEncodingMetaData.getLocale(), localeEncodingMetaData.getEncoding());
                }
            }
            if (this.predicatedHandlers != null && !this.predicatedHandlers.isEmpty()) {
                d.addOuterHandlerChainWrapper((HandlerWrapper)new RewriteCorrectingHandlerWrappers.PostWrapper());
                d.addOuterHandlerChainWrapper(new HandlerWrapper(){

                    public HttpHandler wrap(HttpHandler handler) {
                        if (UndertowDeploymentInfoService.this.predicatedHandlers.size() == 1) {
                            PredicatedHandler ph = (PredicatedHandler)UndertowDeploymentInfoService.this.predicatedHandlers.get(0);
                            return Handlers.predicate((Predicate)ph.getPredicate(), (HttpHandler)ph.getHandler().wrap(handler), (HttpHandler)handler);
                        }
                        return Handlers.predicates((List)UndertowDeploymentInfoService.this.predicatedHandlers, (HttpHandler)handler);
                    }
                });
                d.addOuterHandlerChainWrapper((HandlerWrapper)new RewriteCorrectingHandlerWrappers.PreWrapper());
            }
            if (this.mergedMetaData.getDefaultEncoding() != null) {
                d.setDefaultEncoding(this.mergedMetaData.getDefaultEncoding());
            } else if (servletContainer.getDefaultEncoding() != null) {
                d.setDefaultEncoding(servletContainer.getDefaultEncoding());
            }
            d.setCrawlerSessionManagerConfig(servletContainer.getCrawlerSessionManagerConfig());
            return d;
        }
        catch (ClassNotFoundException e) {
            throw new StartException((Throwable)e);
        }
    }

    private void handleServletMappings(boolean is22OrOlder, Set<String> seenMappings, Map<String, List<ServletMappingMetaData>> servletMappings, ServletInfo s) {
        List<ServletMappingMetaData> mappings = servletMappings.get(s.getName());
        if (mappings != null) {
            for (ServletMappingMetaData mapping : mappings) {
                for (String pattern : mapping.getUrlPatterns()) {
                    if (is22OrOlder && !pattern.startsWith("*") && !pattern.startsWith("/")) {
                        pattern = "/" + pattern;
                    }
                    if (seenMappings.contains(pattern)) continue;
                    s.addMapping(pattern);
                    seenMappings.add(pattern);
                }
            }
        }
    }

    private static List<AuthMethodConfig> authMethod(String configuredMethod) {
        if (configuredMethod == null) {
            return Collections.singletonList(new AuthMethodConfig("BASIC"));
        }
        return AuthMethodParser.parse(configuredMethod, Collections.singletonMap("CLIENT-CERT", "CLIENT_CERT"));
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    private static HashMap<String, JspPropertyGroup> createJspConfig(JBossWebMetaData metaData) {
        List groups;
        HashMap<String, JspPropertyGroup> result = new HashMap<String, JspPropertyGroup>();
        JspConfigMetaData config = metaData.getJspConfig();
        if (config != null && (groups = config.getPropertyGroups()) != null) {
            for (JspPropertyGroupMetaData group : groups) {
                JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                for (String pattern : group.getUrlPatterns()) {
                    jspPropertyGroup.addUrlPattern(pattern);
                }
                jspPropertyGroup.setElIgnored(group.getElIgnored());
                jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                jspPropertyGroup.setIsXml(group.getIsXml());
                if (group.getIncludePreludes() != null) {
                    for (String includePrelude : group.getIncludePreludes()) {
                        jspPropertyGroup.addIncludePrelude(includePrelude);
                    }
                }
                if (group.getIncludeCodas() != null) {
                    for (String includeCoda : group.getIncludeCodas()) {
                        jspPropertyGroup.addIncludeCoda(includeCoda);
                    }
                }
                jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                jspPropertyGroup.setBuffer(group.getBuffer());
                jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                for (String pattern : jspPropertyGroup.getUrlPatterns()) {
                    result.put(pattern, jspPropertyGroup);
                }
            }
        }
        LinkedHashMap<String, JspPropertyGroup> ret = new LinkedHashMap<String, JspPropertyGroup>();
        ArrayList paths = new ArrayList(result.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String path : paths) {
            ret.put(path, (JspPropertyGroup)result.get(path));
        }
        return ret;
    }

    private static void addListener(ClassLoader classLoader, ComponentRegistry components, DeploymentInfo d, ListenerMetaData listener, boolean programatic) throws ClassNotFoundException {
        ListenerInfo l;
        Class<?> listenerClass = classLoader.loadClass(listener.getListenerClass());
        ManagedReferenceFactory creator = components.createInstanceFactory(listenerClass);
        if (creator != null) {
            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
            l = new ListenerInfo(listenerClass, factory);
        } else {
            l = new ListenerInfo(listenerClass);
        }
        d.addListener(l);
    }

    private static <T> InstanceFactory<T> createInstanceFactory(final ManagedReferenceFactory creator) {
        return new InstanceFactory<T>(){

            public InstanceHandle<T> createInstance() throws InstantiationException {
                final ManagedReference instance = creator.getReference();
                return new InstanceHandle<T>(){

                    public T getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }

    public void addInjectedExecutor(String name, InjectedValue<Executor> injected) {
        this.executorsByName.put(name, injected);
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextValue() {
        return this.securityDomainContextValue;
    }

    public Injector<SessionManagerFactory> getSessionManagerFactoryInjector() {
        return this.sessionManagerFactory;
    }

    public Injector<SessionIdentifierCodec> getSessionIdentifierCodecInjector() {
        return this.sessionIdentifierCodec;
    }

    public InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public InjectedValue<ControlPoint> getControlPointInjectedValue() {
        return this.controlPointInjectedValue;
    }

    public InjectedValue<ComponentRegistry> getComponentRegistryInjectedValue() {
        return this.componentRegistryInjectedValue;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjectedValue() {
        return this.suspendControllerInjectedValue;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentInjectedValue() {
        return this.serverEnvironmentInjectedValue;
    }

    public Injector<BiFunction> getSecurityFunctionInjector() {
        return this.securityFunction;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class UndertowThreadSetupAction
    implements ThreadSetupHandler {
        private final SetupAction action;

        private UndertowThreadSetupAction(SetupAction action) {
            this.action = action;
        }

        public <T, C> ThreadSetupHandler.Action<T, C> create(ThreadSetupHandler.Action<T, C> action) {
            return (exchange, context) -> {
                this.action.setup(Collections.emptyMap());
                try {
                    Object object = action.call(exchange, context);
                    return object;
                }
                finally {
                    this.action.teardown(Collections.emptyMap());
                }
            };
        }
    }

    public static class Builder {
        private JBossWebMetaData mergedMetaData;
        private String deploymentName;
        private HashMap<String, TagLibraryInfo> tldInfo;
        private Module module;
        private ScisMetaData scisMetaData;
        private VirtualFile deploymentRoot;
        private String jaccContextId;
        private List<ServletContextAttribute> attributes;
        private String contextPath;
        private String securityDomain;
        private List<SetupAction> setupActions;
        private Set<VirtualFile> overlays;
        private List<ExpressionFactoryWrapper> expressionFactoryWrappers;
        private List<PredicatedHandler> predicatedHandlers;
        private List<HandlerWrapper> initialHandlerChainWrappers;
        private List<HandlerWrapper> innerHandlerChainWrappers;
        private List<HandlerWrapper> outerHandlerChainWrappers;
        private List<ThreadSetupHandler> threadSetupActions;
        private List<ServletExtension> servletExtensions;
        private SharedSessionManagerConfig sharedSessionManagerConfig;
        private boolean explodedDeployment;
        private WebSocketDeploymentInfo webSocketDeploymentInfo;
        private File tempDir;
        private List<File> externalResources;
        List<Predicate> allowSuspendedRequests;

        Builder setMergedMetaData(JBossWebMetaData mergedMetaData) {
            this.mergedMetaData = mergedMetaData;
            return this;
        }

        public Builder setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder setTldInfo(HashMap<String, TagLibraryInfo> tldInfo) {
            this.tldInfo = tldInfo;
            return this;
        }

        public Builder setModule(Module module) {
            this.module = module;
            return this;
        }

        public Builder setScisMetaData(ScisMetaData scisMetaData) {
            this.scisMetaData = scisMetaData;
            return this;
        }

        public Builder setDeploymentRoot(VirtualFile deploymentRoot) {
            this.deploymentRoot = deploymentRoot;
            return this;
        }

        public Builder setJaccContextId(String jaccContextId) {
            this.jaccContextId = jaccContextId;
            return this;
        }

        public Builder setAttributes(List<ServletContextAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSetupActions(List<SetupAction> setupActions) {
            this.setupActions = setupActions;
            return this;
        }

        public Builder setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setOverlays(Set<VirtualFile> overlays) {
            this.overlays = overlays;
            return this;
        }

        public Builder setExpressionFactoryWrappers(List<ExpressionFactoryWrapper> expressionFactoryWrappers) {
            this.expressionFactoryWrappers = expressionFactoryWrappers;
            return this;
        }

        public Builder setPredicatedHandlers(List<PredicatedHandler> predicatedHandlers) {
            this.predicatedHandlers = predicatedHandlers;
            return this;
        }

        public Builder setInitialHandlerChainWrappers(List<HandlerWrapper> initialHandlerChainWrappers) {
            this.initialHandlerChainWrappers = initialHandlerChainWrappers;
            return this;
        }

        public Builder setInnerHandlerChainWrappers(List<HandlerWrapper> innerHandlerChainWrappers) {
            this.innerHandlerChainWrappers = innerHandlerChainWrappers;
            return this;
        }

        public Builder setOuterHandlerChainWrappers(List<HandlerWrapper> outerHandlerChainWrappers) {
            this.outerHandlerChainWrappers = outerHandlerChainWrappers;
            return this;
        }

        public Builder setThreadSetupActions(List<ThreadSetupHandler> threadSetupActions) {
            this.threadSetupActions = threadSetupActions;
            return this;
        }

        public Builder setExplodedDeployment(boolean explodedDeployment) {
            this.explodedDeployment = explodedDeployment;
            return this;
        }

        public List<ServletExtension> getServletExtensions() {
            return this.servletExtensions;
        }

        public Builder setServletExtensions(List<ServletExtension> servletExtensions) {
            this.servletExtensions = servletExtensions;
            return this;
        }

        public Builder setSharedSessionManagerConfig(SharedSessionManagerConfig sharedSessionManagerConfig) {
            this.sharedSessionManagerConfig = sharedSessionManagerConfig;
            return this;
        }

        public Builder setWebSocketDeploymentInfo(WebSocketDeploymentInfo webSocketDeploymentInfo) {
            this.webSocketDeploymentInfo = webSocketDeploymentInfo;
            return this;
        }

        public File getTempDir() {
            return this.tempDir;
        }

        public Builder setTempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder setAllowSuspendedRequests(List<Predicate> allowSuspendedRequests) {
            this.allowSuspendedRequests = allowSuspendedRequests;
            return this;
        }

        public Builder setExternalResources(List<File> externalResources) {
            this.externalResources = externalResources;
            return this;
        }

        public UndertowDeploymentInfoService createUndertowDeploymentInfoService() {
            return new UndertowDeploymentInfoService(this.mergedMetaData, this.deploymentName, this.tldInfo, this.module, this.scisMetaData, this.deploymentRoot, this.jaccContextId, this.securityDomain, this.attributes, this.contextPath, this.setupActions, this.overlays, this.expressionFactoryWrappers, this.predicatedHandlers, this.initialHandlerChainWrappers, this.innerHandlerChainWrappers, this.outerHandlerChainWrappers, this.threadSetupActions, this.explodedDeployment, this.servletExtensions, this.sharedSessionManagerConfig, this.webSocketDeploymentInfo, this.tempDir, this.externalResources, this.allowSuspendedRequests);
        }
    }

    private static class ManagedReferenceInstanceFactory<T>
    implements InstanceFactory<T> {
        private final ManagedReferenceFactory component;

        public ManagedReferenceInstanceFactory(ManagedReferenceFactory component) {
            this.component = component;
        }

        public InstanceHandle<T> createInstance() throws InstantiationException {
            final ManagedReference reference = this.component.getReference();
            return new InstanceHandle<T>(){

                public T getInstance() {
                    return reference.getInstance();
                }

                public void release() {
                    reference.release();
                }
            };
        }
    }

    private static class ComponentClassIntrospector
    implements ClassIntrospecter {
        private final ComponentRegistry componentRegistry;

        public ComponentClassIntrospector(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
        }

        public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
            ManagedReferenceFactory component = this.componentRegistry.createInstanceFactory(clazz);
            return new ManagedReferenceInstanceFactory(component);
        }
    }
}

