/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AbstractPersistentSessionManager;
import org.wildfly.extension.undertow.DiskBasedModularPersistentSessionManager;
import org.wildfly.extension.undertow.InMemoryModularPersistentSessionManager;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

class PersistentSessionsDefinition
extends PersistentResourceDefinition {
    static final PersistentSessionsDefinition INSTANCE = new PersistentSessionsDefinition();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{PATH, RELATIVE_TO};
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();

    private PersistentSessionsDefinition() {
        super(UndertowExtension.PATH_PERSISTENT_SESSIONS, (ResourceDescriptionResolver)UndertowExtension.getResolver(UndertowExtension.PATH_PERSISTENT_SESSIONS.getKeyValuePair()), (OperationStepHandler)new PersistentSessionsAdd(), (OperationStepHandler)new PersistentSessionsRemove());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public static boolean isEnabled(OperationContext context, ModelNode model) throws OperationFailedException {
        return model.isDefined();
    }

    static {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
    }

    private static class PersistentSessionsRemove
    extends RestartParentResourceRemoveHandler {
        protected PersistentSessionsRemove() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
            super.removeServices(context, parentService, parentModel);
            context.removeService(AbstractPersistentSessionManager.SERVICE_NAME);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }

    private static class PersistentSessionsAdd
    extends RestartParentResourceAddHandler {
        protected PersistentSessionsAdd() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            if (this.requiresRuntime(context)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        this.performRuntime(context, operation, operation);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                this.rollbackRuntime(context, operation, operation);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        private void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (PersistentSessionsDefinition.isEnabled(context, model)) {
                ServiceBuilder builder;
                ModelNode pathValue = PATH.resolveModelAttribute(context, model);
                if (pathValue.isDefined()) {
                    String path = pathValue.asString();
                    ModelNode relativeToValue = RELATIVE_TO.resolveModelAttribute(context, model);
                    String relativeTo = relativeToValue.isDefined() ? relativeToValue.asString() : null;
                    DiskBasedModularPersistentSessionManager service = new DiskBasedModularPersistentSessionManager(path, relativeTo);
                    builder = context.getServiceTarget().addService(AbstractPersistentSessionManager.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, service.getModuleLoaderInjectedValue()).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManager());
                } else {
                    InMemoryModularPersistentSessionManager service = new InMemoryModularPersistentSessionManager();
                    builder = context.getServiceTarget().addService(AbstractPersistentSessionManager.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, service.getModuleLoaderInjectedValue());
                }
                builder.install();
            }
        }

        private void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (SimpleAttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }
}

