/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.idm.X509CertificateCredential;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.callback.DigestCallbackHandler;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.digest.DigestCredential;

public class JAASIdentityManagerImpl
implements IdentityManager {
    private final SecurityDomainContext securityDomainContext;

    public JAASIdentityManagerImpl(SecurityDomainContext securityDomainContext) {
        this.securityDomainContext = securityDomainContext;
    }

    public Account verify(Account account) {
        if (!(account instanceof AccountImpl)) {
            UndertowLogger.ROOT_LOGGER.tracef("Account is not an AccountImpl", account);
            return null;
        }
        AccountImpl accountImpl = (AccountImpl)account;
        return this.verifyCredential(accountImpl, accountImpl.getCredential());
    }

    public Account verify(String id, Credential credential) {
        AccountImpl account = this.getAccount(id);
        if (credential instanceof DigestCredential) {
            DigestCredential digestCredential = (DigestCredential)credential;
            DigestCallbackHandler handler = new DigestCallbackHandler(id, digestCredential.getNonce(), digestCredential.getNonceCount(), digestCredential.getClientNonce(), digestCredential.getQop(), digestCredential.getRealm(), digestCredential.getHA2());
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
            return this.verifyCredential(account, digestCredential.getClientDigest());
        }
        if (credential instanceof PasswordCredential) {
            char[] password = ((PasswordCredential)credential).getPassword();
            char[] duplicate = Arrays.copyOf(password, password.length);
            return this.verifyCredential(account, duplicate);
        }
        return this.verifyCredential(account, credential);
    }

    public Account verify(Credential credential) {
        if (credential instanceof X509CertificateCredential) {
            X509CertificateCredential certCredential = (X509CertificateCredential)credential;
            X509Certificate certificate = certCredential.getCertificate();
            AccountImpl account = this.getAccount(certificate.getSubjectDN().getName());
            return this.verifyCredential(account, certificate);
        }
        throw new IllegalArgumentException("Parameter must be a X509CertificateCredential");
    }

    private AccountImpl getAccount(String id) {
        return new AccountImpl(id);
    }

    private Account verifyCredential(AccountImpl account, Object credential) {
        AuthenticationManager authenticationManager = this.securityDomainContext.getAuthenticationManager();
        AuthorizationManager authorizationManager = this.securityDomainContext.getAuthorizationManager();
        SecurityContext sc = SecurityActions.getSecurityContext();
        Principal incomingPrincipal = account.getOriginalPrincipal();
        Subject subject = new Subject();
        try {
            boolean isValid = authenticationManager.isValid(incomingPrincipal, credential, subject);
            if (isValid) {
                UndertowLogger.ROOT_LOGGER.tracef("User: %s is authenticated", incomingPrincipal);
                if (sc == null) {
                    throw UndertowLogger.ROOT_LOGGER.noSecurityContext();
                }
                Principal userPrincipal = this.getPrincipal(subject);
                sc.getUtil().createSubjectInfo(incomingPrincipal, credential, subject);
                SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
                RoleGroup roles = authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
                HashSet<String> roleSet = new HashSet<String>();
                for (Role role : roles.getRoles()) {
                    roleSet.add(role.getRoleName());
                }
                return new AccountImpl(userPrincipal, roleSet, credential, account.getOriginalPrincipal());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }
}

