/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.jboss.common.beans.property.BeanUtils;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ConfiguredHandlerWrapper
implements HandlerWrapper {
    private final Class<?> handlerClass;
    private final Map<String, String> properties;

    public ConfiguredHandlerWrapper(Class<?> handlerClass, Map<String, String> properties) {
        this.handlerClass = handlerClass;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandler wrap(HttpHandler handler) {
        try {
            Object instance;
            if (HttpHandler.class.isAssignableFrom(this.handlerClass)) {
                Constructor<?> ctor = this.handlerClass.getConstructor(HttpHandler.class);
                ClassLoader prevCL = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.handlerClass);
                try {
                    instance = ctor.newInstance(handler);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)prevCL);
                }
            } else if (HandlerWrapper.class.isAssignableFrom(this.handlerClass)) {
                ClassLoader prevCL = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.handlerClass);
                try {
                    instance = this.handlerClass.newInstance();
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)prevCL);
                }
            } else {
                throw UndertowLogger.ROOT_LOGGER.handlerWasNotAHandlerOrWrapper(this.handlerClass);
            }
            Properties p = new Properties();
            p.putAll(this.properties);
            ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(BeanUtils.class);
                BeanUtils.mapJavaBeanProperties(instance, (Properties)p);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
            }
            if (HttpHandler.class.isAssignableFrom(this.handlerClass)) {
                return (HttpHandler)instance;
            }
            return ((HandlerWrapper)instance).wrap(handler);
        }
        catch (Exception e) {
            throw UndertowLogger.ROOT_LOGGER.failedToConfigureHandler(this.handlerClass, e);
        }
    }
}

