/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.parser.servlet.WebFragmentMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class WebFragmentParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        HashMap<String, WebFragmentMetaData> webFragments = warMetaData.getWebFragmentsMetaData();
        if (webFragments == null) {
            webFragments = new HashMap<String, WebFragmentMetaData>();
            warMetaData.setWebFragmentsMetaData(webFragments);
        }
        List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile webFragment;
            if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(webFragment = resourceRoot.getRoot().getChild(WEB_FRAGMENT_XML)).exists() || !webFragment.isFile()) continue;
            InputStream is = null;
            try {
                is = webFragment.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXMLResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                WebFragmentMetaData webFragmentMetaData = WebFragmentMetaDataParser.parse((XMLStreamReader)xmlReader, (PropertyReplacer)SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
                webFragments.put(resourceRoot.getRootName(), webFragmentMetaData);
                if (warMetaData.getWebMetaData() == null || warMetaData.getWebMetaData().getDistributable() == null || webFragmentMetaData.getDistributable() != null) continue;
                UndertowLogger.ROOT_LOGGER.distributableDisabledInFragmentXml(deploymentUnit.getName(), resourceRoot.getRootName());
            }
            catch (XMLStreamException e) {
                throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(webFragment.toString(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()));
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(webFragment.toString()), (Throwable)e);
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

