/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.servlet.api.SessionConfigWrapper;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.web.session.AffinityLocator;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.session.AffinitySessionConfigWrapper;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;

public class SessionConfigWrapperFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<CookieConfig, SessionConfigWrapper> {
    private final SupplierDependency<SessionIdentifierCodec> codecDependency;
    private final SupplierDependency<AffinityLocator> locatorDependency;

    public SessionConfigWrapperFactoryServiceConfigurator(ServiceName name, SupplierDependency<SessionIdentifierCodec> codecDependency, SupplierDependency<AffinityLocator> locatorDependency) {
        super(name);
        this.codecDependency = codecDependency;
        this.locatorDependency = locatorDependency;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer function = new CompositeDependency(new Dependency[]{this.codecDependency, this.locatorDependency}).register(builder).provides(new ServiceName[]{name});
        return builder.setInstance(Service.newInstance((Consumer)function, (Object)this));
    }

    @Override
    public SessionConfigWrapper apply(CookieConfig config) {
        return config != null ? new AffinitySessionConfigWrapper(config, (AffinityLocator)this.locatorDependency.get()) : new CodecSessionConfigWrapper((SessionIdentifierCodec)this.codecDependency.get());
    }
}

