/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SimpleRoutingSupport;
import org.jboss.as.web.session.SimpleSessionIdentifierCodec;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.extension.undertow.Host;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

final class HttpInvokerHostService
implements Service {
    private static final String JSESSIONID = "JSESSIONID";
    private final Supplier<Host> host;
    private final Supplier<HttpAuthenticationFactory> httpAuthenticationFactory;
    private final Supplier<PathHandler> remoteHttpInvokerService;
    private final String path;

    HttpInvokerHostService(Supplier<Host> host, Supplier<HttpAuthenticationFactory> httpAuthenticationFactory, Supplier<PathHandler> remoteHttpInvokerService, String path) {
        this.host = host;
        this.httpAuthenticationFactory = httpAuthenticationFactory;
        this.remoteHttpInvokerService = remoteHttpInvokerService;
        this.path = path;
    }

    public void start(StartContext startContext) {
        HttpHandler handler = (HttpHandler)this.remoteHttpInvokerService.get();
        if (this.httpAuthenticationFactory != null) {
            handler = HttpInvokerHostService.secureAccess(handler, this.httpAuthenticationFactory.get());
        }
        handler = this.setupRoutes(handler);
        this.host.get().registerHandler(this.path, handler);
        this.host.get().registerLocation(this.path);
    }

    public void stop(StopContext stopContext) {
        this.host.get().unregisterHandler(this.path);
        this.host.get().unregisterLocation(this.path);
    }

    private HttpHandler setupRoutes(HttpHandler handler) {
        SimpleSessionIdentifierCodec codec = new SimpleSessionIdentifierCodec((RoutingSupport)new SimpleRoutingSupport(), this.host.get().getServer().getRoute());
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        return exchange -> {
            exchange.addResponseCommitListener(ex -> {
                Cookie cookie = (Cookie)ex.getResponseCookies().get(JSESSIONID);
                if (cookie != null) {
                    cookie.setValue(codec.encode((CharSequence)cookie.getValue()).toString());
                } else if (ex.getStatusCode() == 401) {
                    cookie = new CookieImpl(JSESSIONID, codec.encode((CharSequence)generator.createSessionId()).toString());
                    cookie.setPath(ex.getResolvedPath());
                    exchange.getResponseCookies().put(JSESSIONID, cookie);
                }
            });
            handler.handleRequest(exchange);
        };
    }

    private static HttpHandler secureAccess(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        domainHandler = new AuthenticationCallHandler(domainHandler);
        domainHandler = new AuthenticationConstraintHandler(domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext(domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange2;
                super(httpServerExchange);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }

    public String getPath() {
        return this.path;
    }
}

