/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.Handlers;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Methods;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.DefaultResponseCodeHandler;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.LocationService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowFilter;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.GateHandlerWrapper;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;

public class Host
implements Service<Host>,
FilterLocation {
    public static final BinaryServiceDescriptor<Host> SERVICE_DESCRIPTOR = BinaryServiceDescriptor.of((String)"org.wildfly.undertow.host", Host.class);
    private final Consumer<Host> serviceConsumer;
    private final Supplier<Server> server;
    private final Supplier<UndertowService> undertowService;
    private final Supplier<ControlledProcessStateService> controlledProcessStateService;
    private final Supplier<SuspendController> suspendController;
    private final PathHandler pathHandler = new PathHandler();
    private final Set<String> allAliases;
    private final String name;
    private final String defaultWebModule;
    private final List<UndertowFilter> filters = new CopyOnWriteArrayList<UndertowFilter>();
    private final Set<Deployment> deployments = new CopyOnWriteArraySet<Deployment>();
    private final Map<String, LocationService> locations = new CopyOnWriteMap();
    private final Map<String, AuthenticationMechanism> additionalAuthenticationMechanisms = new ConcurrentHashMap<String, AuthenticationMechanism>();
    private final HostRootHandler hostRootHandler = new HostRootHandler();
    private final DefaultResponseCodeHandler defaultHandler;
    private final Boolean queueRequestsOnStart;
    private final int defaultResponseCode;
    private volatile HttpHandler rootHandler = null;
    private volatile AccessLogService accessLogService;
    private volatile GateHandlerWrapper gateHandlerWrapper;
    private volatile Function<HttpHandler, HttpHandler> accessLogHttpHandler;
    ServerActivity suspendListener = new ServerActivity(){

        public void preSuspend(ServerActivityCallback listener) {
            Host.this.defaultHandler.setSuspended(true);
            listener.done();
        }

        public void suspended(ServerActivityCallback listener) {
            listener.done();
        }

        public void resume() {
            Host.this.defaultHandler.setSuspended(false);
        }
    };

    public Host(Consumer<Host> serviceConsumer, Supplier<Server> server, Supplier<UndertowService> undertowService, Supplier<ControlledProcessStateService> controlledProcessStateService, Supplier<SuspendController> suspendController, String name, List<String> aliases, String defaultWebModule, int defaultResponseCode, Boolean queueRequestsOnStart) {
        this.serviceConsumer = serviceConsumer;
        this.server = server;
        this.undertowService = undertowService;
        this.controlledProcessStateService = controlledProcessStateService;
        this.suspendController = suspendController;
        this.name = name;
        this.defaultWebModule = defaultWebModule;
        HashSet<String> hosts = new HashSet<String>(aliases.size() + 1);
        hosts.add(name);
        hosts.addAll(aliases);
        this.allAliases = Collections.unmodifiableSet(hosts);
        this.queueRequestsOnStart = queueRequestsOnStart;
        this.defaultHandler = new DefaultResponseCodeHandler(defaultResponseCode);
        this.defaultResponseCode = defaultResponseCode;
        this.setupDefaultResponseCodeHandler();
    }

    private String getDeployedContextPath(DeploymentInfo deploymentInfo) {
        return "".equals(deploymentInfo.getContextPath()) ? "/" : deploymentInfo.getContextPath();
    }

    public void start(StartContext context) throws StartException {
        this.suspendController.get().registerActivity(this.suspendListener);
        SuspensionStateProvider.State state = this.suspendController.get().getState();
        if (state == SuspensionStateProvider.State.RUNNING) {
            this.defaultHandler.setSuspended(false);
        } else {
            this.defaultHandler.setSuspended(true);
        }
        final ControlledProcessStateService controlledProcessStateService = this.controlledProcessStateService.get();
        if (controlledProcessStateService != null && controlledProcessStateService.getCurrentState() == ControlledProcessState.State.STARTING) {
            boolean nonGraceful = state == SuspensionStateProvider.State.RUNNING;
            int statusCode = this.defaultResponseCode;
            if (nonGraceful && this.queueRequestsOnStart == null) {
                UndertowLogger.ROOT_LOGGER.debug("Running in non-graceful mode and " + HostDefinition.QUEUE_REQUESTS_ON_START.getName() + " not explicitly set. Requests will not be queued.");
            } else {
                if (this.queueRequestsOnStart == null || Boolean.TRUE.equals(this.queueRequestsOnStart)) {
                    UndertowLogger.ROOT_LOGGER.info("Queuing requests.");
                    statusCode = -1;
                }
                this.gateHandlerWrapper = new GateHandlerWrapper(statusCode);
                controlledProcessStateService.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        controlledProcessStateService.removePropertyChangeListener((PropertyChangeListener)this);
                        if (Host.this.gateHandlerWrapper != null) {
                            Host.this.gateHandlerWrapper.open();
                            Host.this.gateHandlerWrapper = null;
                        }
                        Host.this.rootHandler = null;
                    }
                });
            }
        }
        this.server.get().registerHost(this);
        UndertowLogger.ROOT_LOGGER.hostStarting(this.name);
        this.serviceConsumer.accept(this);
    }

    private HttpHandler configureRootHandler() {
        Path base;
        AccessLogService logService = this.accessLogService;
        Object rootHandler = this.pathHandler;
        Function<HttpHandler, HttpHandler> accessLogHttpHandler = this.accessLogHttpHandler;
        ArrayList<UndertowFilter> filters = new ArrayList<UndertowFilter>(this.filters);
        rootHandler = new OptionsHandler((HttpHandler)rootHandler);
        rootHandler = Handlers.httpContinueRead((HttpHandler)rootHandler);
        rootHandler = LocationService.configureHandlerChain((HttpHandler)rootHandler, filters);
        if (logService != null) {
            rootHandler = logService.configureAccessLogHandler((HttpHandler)rootHandler);
        }
        if (accessLogHttpHandler != null) {
            rootHandler = accessLogHttpHandler.apply((HttpHandler)rootHandler);
        }
        String path = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", (String)".");
        try {
            base = Paths.get(path, new String[0]).normalize().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int cacheBufferSize = 1024;
        int cacheBuffers = 1024;
        PathResourceManager resourceManager = new PathResourceManager(base, 0x100000L, true, false, new String[0]);
        rootHandler = new AcmeResourceHandler((ResourceManager)resourceManager, (HttpHandler)rootHandler);
        GateHandlerWrapper gateHandlerWrapper = this.gateHandlerWrapper;
        if (gateHandlerWrapper != null) {
            rootHandler = gateHandlerWrapper.wrap((HttpHandler)rootHandler);
        }
        return rootHandler;
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.server.get().unregisterHost(this);
        this.pathHandler.clearPaths();
        if (this.gateHandlerWrapper != null) {
            this.gateHandlerWrapper.open();
            this.gateHandlerWrapper = null;
        }
        UndertowLogger.ROOT_LOGGER.hostStopping(this.name);
        this.suspendController.get().unRegisterActivity(this.suspendListener);
    }

    public Host getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    void setAccessLogService(AccessLogService service) {
        this.accessLogService = service;
        this.rootHandler = null;
    }

    void setAccessLogHandler(Function<HttpHandler, HttpHandler> accessLogHttpHandler) {
        this.accessLogHttpHandler = accessLogHttpHandler;
        this.rootHandler = null;
    }

    public Server getServer() {
        return this.server.get();
    }

    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    public String getName() {
        return this.name;
    }

    protected HttpHandler getRootHandler() {
        return this.hostRootHandler;
    }

    List<UndertowFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpHandler getOrCreateRootHandler() {
        HttpHandler root = this.rootHandler;
        if (root == null) {
            Host host = this;
            synchronized (host) {
                root = this.rootHandler;
                if (root == null) {
                    this.rootHandler = this.configureRootHandler();
                    return this.rootHandler;
                }
            }
        }
        return root;
    }

    public String getDefaultWebModule() {
        return this.defaultWebModule;
    }

    public void registerDeployment(Deployment deployment, HttpHandler handler) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        this.registerHandler(path, handler);
        this.deployments.add(deployment);
        UndertowLogger.ROOT_LOGGER.registerWebapp(path, this.getServer().getName());
        this.undertowService.get().fireEvent(listener -> listener.onDeploymentStart(deployment, this));
    }

    public void unregisterDeployment(Deployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        this.undertowService.get().fireEvent(listener -> listener.onDeploymentStop(deployment, this));
        this.unregisterHandler(path);
        this.deployments.remove(deployment);
        UndertowLogger.ROOT_LOGGER.unregisterWebapp(path, this.getServer().getName());
    }

    void registerLocation(String path) {
        Object realPath = path.startsWith("/") ? path : "/" + path;
        this.locations.put((String)realPath, null);
        this.undertowService.get().fireEvent(arg_0 -> this.lambda$registerLocation$2((String)realPath, arg_0));
    }

    void unregisterLocation(String path) {
        Object realPath = path.startsWith("/") ? path : "/" + path;
        this.locations.remove(realPath);
        this.undertowService.get().fireEvent(arg_0 -> this.lambda$unregisterLocation$3((String)realPath, arg_0));
    }

    public void registerHandler(String path, HttpHandler handler) {
        this.pathHandler.addPrefixPath(path, handler);
    }

    public void unregisterHandler(String path) {
        this.pathHandler.removePrefixPath(path);
        LocationService location = this.locations.get(path);
        if (location != null) {
            this.pathHandler.addPrefixPath(location.getLocationPath(), (HttpHandler)location.getLocationHandler());
        } else if (path.equals("/")) {
            this.setupDefaultResponseCodeHandler();
        }
    }

    void registerLocation(LocationService location) {
        this.locations.put(location.getLocationPath(), location);
        this.registerHandler(location.getLocationPath(), location.getLocationHandler());
        this.undertowService.get().fireEvent(listener -> listener.onDeploymentStart(location.getLocationPath(), this));
    }

    void unregisterLocation(LocationService location) {
        this.locations.remove(location.getLocationPath());
        this.unregisterHandler(location.getLocationPath());
        this.undertowService.get().fireEvent(listener -> listener.onDeploymentStop(location.getLocationPath(), this));
    }

    public Set<String> getLocations() {
        return Collections.unmodifiableSet(this.locations.keySet());
    }

    public Set<Deployment> getDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }

    void registerAdditionalAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism) {
        this.additionalAuthenticationMechanisms.put(name, authenticationMechanism);
    }

    void unregisterAdditionalAuthenticationMechanism(String name) {
        this.additionalAuthenticationMechanisms.remove(name);
    }

    public Map<String, AuthenticationMechanism> getAdditionalAuthenticationMechanisms() {
        return new LinkedHashMap<String, AuthenticationMechanism>(this.additionalAuthenticationMechanisms);
    }

    @Override
    public void addFilter(UndertowFilter filterRef) {
        this.filters.add(filterRef);
        this.rootHandler = null;
    }

    @Override
    public void removeFilter(UndertowFilter filterRef) {
        this.filters.remove(filterRef);
        this.rootHandler = null;
    }

    public SuspensionStateProvider.State getSuspendState() {
        return this.suspendController.get().getState();
    }

    protected void setupDefaultResponseCodeHandler() {
        if (this.defaultHandler != null) {
            this.registerHandler("/", this.defaultHandler);
        }
    }

    private /* synthetic */ void lambda$unregisterLocation$3(String realPath, UndertowEventListener listener) {
        listener.onDeploymentStop(realPath, this);
    }

    private /* synthetic */ void lambda$registerLocation$2(String realPath, UndertowEventListener listener) {
        listener.onDeploymentStart(realPath, this);
    }

    private class HostRootHandler
    implements HttpHandler {
        private HostRootHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            Host.this.getOrCreateRootHandler().handleRequest(exchange);
        }
    }

    private static final class OptionsHandler
    implements HttpHandler {
        private final HttpHandler next;

        private OptionsHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestMethod().equals(Methods.OPTIONS) && exchange.getRelativePath().equals("*")) {
                exchange.endExchange();
                return;
            }
            this.next.handleRequest(exchange);
        }
    }

    private static final class AcmeResourceHandler
    extends ResourceHandler {
        private static final String ACME_CHALLENGE_CONTEXT = "/.well-known/acme-challenge/";
        private static final Pattern ACME_CHALLENGE_PATTERN = Pattern.compile("/\\.well-known/acme-challenge/[A-Za-z0-9_-]+");
        private final HttpHandler next;

        private AcmeResourceHandler(ResourceManager resourceManager, HttpHandler next) {
            super(resourceManager, next);
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestMethod().equals(Methods.GET) && exchange.getRelativePath().startsWith(ACME_CHALLENGE_CONTEXT, 0) && ACME_CHALLENGE_PATTERN.matcher(exchange.getRelativePath()).matches()) {
                super.handleRequest(exchange);
            } else {
                this.next.handleRequest(exchange);
            }
        }
    }
}

