/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AbstractPersistentSessionManager;
import org.wildfly.extension.undertow.DiskBasedModularPersistentSessionManager;
import org.wildfly.extension.undertow.InMemoryModularPersistentSessionManager;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;

class PersistentSessionsDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"setting", (String)"persistent-sessions");
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(PATH, RELATIVE_TO);

    PersistentSessionsDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getKeyValuePair())).setAddHandler((OperationStepHandler)new PersistentSessionsAdd()).setRemoveHandler((OperationStepHandler)new PersistentSessionsRemove()));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public static boolean isEnabled(ModelNode model) throws OperationFailedException {
        return model.isDefined();
    }

    private static class PersistentSessionsAdd
    extends RestartParentResourceAddHandler {
        protected PersistentSessionsAdd() {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            if (this.requiresRuntime(context)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        this.performRuntime(context, operation, operation);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                this.rollbackRuntime(context, operation, operation);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        private void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (PersistentSessionsDefinition.isEnabled(model)) {
                ModelNode pathValue = PATH.resolveModelAttribute(context, model);
                CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addService(AbstractPersistentSessionManager.SERVICE_NAME);
                Consumer sConsumer = sb.provides(new ServiceName[]{AbstractPersistentSessionManager.SERVICE_NAME});
                Supplier mlSupplier = sb.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
                if (pathValue.isDefined()) {
                    String path = pathValue.asString();
                    ModelNode relativeToValue = RELATIVE_TO.resolveModelAttribute(context, model);
                    String relativeTo = relativeToValue.isDefined() ? relativeToValue.asString() : null;
                    Supplier pmSupplier = sb.requires(PathManager.SERVICE_DESCRIPTOR);
                    sb.setInstance((Service)new DiskBasedModularPersistentSessionManager(sConsumer, mlSupplier, pmSupplier, path, relativeTo));
                } else {
                    sb.setInstance((Service)new InMemoryModularPersistentSessionManager(sConsumer, mlSupplier));
                }
                sb.install();
            }
        }

        private void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }

    private static class PersistentSessionsRemove
    extends RestartParentResourceRemoveHandler {
        protected PersistentSessionsRemove() {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
        }

        protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
            super.removeServices(context, parentService, parentModel);
            context.removeService(AbstractPersistentSessionManager.SERVICE_NAME);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }
}

