/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowLogger;

class JspDefinition
extends PersistentResourceDefinition {
    static final JspDefinition INSTANCE = new JspDefinition();
    protected static final SimpleAttributeDefinition DEVELOPMENT = new SimpleAttributeDefinitionBuilder("development", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition DISABLED = new SimpleAttributeDefinitionBuilder("disabled", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition KEEP_GENERATED = new SimpleAttributeDefinitionBuilder("keep-generated", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition TRIM_SPACES = new SimpleAttributeDefinitionBuilder("trim-spaces", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition TAG_POOLING = new SimpleAttributeDefinitionBuilder("tag-pooling", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition MAPPED_FILE = new SimpleAttributeDefinitionBuilder("mapped-file", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition CHECK_INTERVAL = new SimpleAttributeDefinitionBuilder("check-interval", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(0)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition MODIFICATION_TEST_INTERVAL = new SimpleAttributeDefinitionBuilder("modification-test-interval", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(4)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition RECOMPILE_ON_FAIL = new SimpleAttributeDefinitionBuilder("recompile-on-fail", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition SMAP = new SimpleAttributeDefinitionBuilder("smap", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition DUMP_SMAP = new SimpleAttributeDefinitionBuilder("dump-smap", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition GENERATE_STRINGS_AS_CHAR_ARRAYS = new SimpleAttributeDefinitionBuilder("generate-strings-as-char-arrays", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE = new SimpleAttributeDefinitionBuilder("error-on-use-bean-invalid-class-attribute", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition SCRATCH_DIR = new SimpleAttributeDefinitionBuilder("scratch-dir", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition SOURCE_VM = new SimpleAttributeDefinitionBuilder("source-vm", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setDefaultValue(new ModelNode("1.6")).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition TARGET_VM = new SimpleAttributeDefinitionBuilder("target-vm", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setDefaultValue(new ModelNode("1.6")).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition JAVA_ENCODING = new SimpleAttributeDefinitionBuilder("java-encoding", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setDefaultValue(new ModelNode("UTF8")).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition X_POWERED_BY = new SimpleAttributeDefinitionBuilder("x-powered-by", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true)).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition DISPLAY_SOURCE_FRAGMENT = new SimpleAttributeDefinitionBuilder("display-source-fragment", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true)).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{DEVELOPMENT, DISABLED, KEEP_GENERATED, TRIM_SPACES, TAG_POOLING, MAPPED_FILE, CHECK_INTERVAL, MODIFICATION_TEST_INTERVAL, RECOMPILE_ON_FAIL, SMAP, DUMP_SMAP, GENERATE_STRINGS_AS_CHAR_ARRAYS, ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE, SCRATCH_DIR, SOURCE_VM, TARGET_VM, JAVA_ENCODING, X_POWERED_BY, DISPLAY_SOURCE_FRAGMENT};
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();

    private JspDefinition() {
        super(UndertowExtension.PATH_JSP, (ResourceDescriptionResolver)UndertowExtension.getResolver(UndertowExtension.PATH_JSP.getKeyValuePair()), (OperationStepHandler)new JSPAdd(), (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    static {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
    }

    private static class JSPAdd
    extends AbstractBoottimeAddStepHandler {
        private JSPAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (SimpleAttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext", true, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                UndertowLogger.ROOT_LOGGER.couldNotInitJsp(e);
            }
        }
    }
}

