/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.undertow.AbstractListenerResourceDefinition;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.Pool;
import org.xnio.XnioWorker;

abstract class AbstractListenerAdd
extends AbstractAddStepHandler {
    private final AbstractListenerResourceDefinition listenerDefinition;

    AbstractListenerAdd(AbstractListenerResourceDefinition definition) {
        this.listenerDefinition = definition;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.listenerDefinition.getAttributes()) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parent = address.subAddress(0, address.size() - 1);
        String name = address.getLastElement().getValue();
        String bindingRef = AbstractListenerResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        String workerName = AbstractListenerResourceDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String bufferPoolName = AbstractListenerResourceDefinition.BUFFER_POOL.resolveModelAttribute(context, model).asString();
        boolean enabled = AbstractListenerResourceDefinition.ENABLED.resolveModelAttribute(context, model).asBoolean();
        String serverName = parent.getLastElement().getValue();
        if (enabled) {
            AbstractListenerService<? extends AbstractListenerService> service = this.createService(name, serverName, context, model);
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(this.constructServiceName(name), service);
            serviceBuilder.addDependency(IOServices.WORKER.append(new String[]{workerName}), XnioWorker.class, service.getWorker()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding()).addDependency(IOServices.BUFFER_POOL.append(new String[]{bufferPoolName}), Pool.class, service.getBufferPool()).addDependency(UndertowService.SERVER.append(new String[]{serverName}), Server.class, service.getServerService());
            this.configureAdditionalDependencies(context, (ServiceBuilder<? extends AbstractListenerService>)serviceBuilder, model, service);
            ServiceController serviceController = serviceBuilder.install();
            if (newControllers != null) {
                newControllers.add(serviceController);
            }
        }
    }

    abstract ServiceName constructServiceName(String var1);

    abstract AbstractListenerService<? extends AbstractListenerService> createService(String var1, String var2, OperationContext var3, ModelNode var4) throws OperationFailedException;

    abstract void configureAdditionalDependencies(OperationContext var1, ServiceBuilder<? extends AbstractListenerService> var2, ModelNode var3, AbstractListenerService var4) throws OperationFailedException;
}

