/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.ArrayList;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.HostAdd;
import org.wildfly.extension.undertow.UndertowService;

class HostRemove
extends AbstractRemoveStepHandler {
    HostRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parent = address.subAddress(0, address.size() - 1);
        String name = address.getLastElement().getValue();
        String serverName = parent.getLastElement().getValue();
        ServiceName virtualHostServiceName = UndertowService.virtualHostName(serverName, name);
        context.removeService(virtualHostServiceName);
        ServiceName consoleRedirectName = UndertowService.consoleRedirectServiceName(serverName, name);
        context.removeService(consoleRedirectName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            HostAdd.INSTANCE.performRuntime(context, operation, model, new ServiceVerificationHandler(), new ArrayList());
        } else {
            context.revertReloadRequired();
        }
    }
}

