/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.ServletInfo;
import org.apache.jasper.servlet.JspServlet;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class JSPService
implements Service<JSPService> {
    private final ModelNode config;
    private final ServletInfo servletInfo;

    public JSPService(ModelNode config) {
        this.config = config;
        this.servletInfo = this.configureServletInfo();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public JSPService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private ServletInfo configureServletInfo() {
        boolean disabled = this.config.get("disabled").asBoolean(false);
        if (disabled) {
            return null;
        }
        ServletInfo jspServlet = new ServletInfo("Default JSP Servlet", JspServlet.class).addMapping("*.jsp").addMapping("*.jspx");
        jspServlet.addInitParam("development", this.config.require("development").asString());
        jspServlet.addInitParam("keepgenerated", this.config.require("keep-generated").asString());
        jspServlet.addInitParam("trimSpaces", this.config.require("trim-spaces").asString());
        jspServlet.addInitParam("enablePooling", this.config.require("tag-pooling").asString());
        jspServlet.addInitParam("mappedfile", this.config.require("mapped-file").asString());
        jspServlet.addInitParam("checkInterval", this.config.require("check-interval").asString());
        jspServlet.addInitParam("modificationTestInterval", this.config.require("modification-test-interval").asString());
        jspServlet.addInitParam("recompileOnFail", this.config.require("recompile-on-fail").asString());
        jspServlet.addInitParam("suppressSmap", Boolean.toString(!this.config.require("smap").asBoolean()));
        jspServlet.addInitParam("dumpSmap", this.config.require("dump-smap").asString());
        jspServlet.addInitParam("genStringAsCharArray", this.config.require("generate-strings-as-char-arrays").asString());
        jspServlet.addInitParam("errorOnUseBeanInvalidClassAttribute", this.config.require("error-on-use-bean-invalid-class-attribute").asString());
        if (this.config.hasDefined("scratch-dir")) {
            jspServlet.addInitParam("scratchdir", this.config.require("scratch-dir").asString());
        }
        jspServlet.addInitParam("compilerSourceVM", this.config.require("source-vm").asString());
        jspServlet.addInitParam("compilerTargetVM", this.config.require("target-vm").asString());
        jspServlet.addInitParam("javaEncoding", this.config.require("java-encoding").asString());
        jspServlet.addInitParam("xpoweredBy", this.config.require("x-powered-by").asString());
        jspServlet.addInitParam("displaySourceFragment", this.config.require("display-source-fragment").asString());
        return jspServlet;
    }

    public ServletInfo getJSPServletInfo() {
        return this.servletInfo;
    }
}

