/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;

class ServerAdd
extends AbstractBoottimeAddStepHandler {
    ServerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition def : ServerDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String defaultHost = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, model).asString();
        String servletContainer = ServerDefinition.SERVLET_CONTAINER.resolveModelAttribute(context, model).asString();
        ServiceName serverName = UndertowService.SERVER.append(new String[]{name});
        Server service = new Server(name, defaultHost);
        ServiceBuilder builder = context.getServiceTarget().addService(serverName, (Service)service).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{servletContainer}), ServletContainerService.class, service.getServletContainer()).addDependency(UndertowService.UNDERTOW, UndertowService.class, service.getUndertowService());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController serviceController = builder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
    }
}

