/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.Version;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.web.common.SharedTldsMetaDataBuilder;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilder;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderService;
import org.wildfly.extension.undertow.SharedWebMetaDataBuilder;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebServerService;
import org.wildfly.extension.undertow.deployment.ELExpressionFactoryProcessor;
import org.wildfly.extension.undertow.deployment.EarContextRootProcessor;
import org.wildfly.extension.undertow.deployment.JBossWebParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.ServletContainerInitializerDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.TldParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowDependencyProcessor;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowHandlersDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowJSRWebSocketDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WarAnnotationDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WarDeploymentInitializingProcessor;
import org.wildfly.extension.undertow.deployment.WarMetaDataProcessor;
import org.wildfly.extension.undertow.deployment.WarStructureDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WebComponentProcessor;
import org.wildfly.extension.undertow.deployment.WebFragmentParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WebJBossAllParser;
import org.wildfly.extension.undertow.deployment.WebParsingDeploymentProcessor;

class UndertowSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final UndertowSubsystemAdd INSTANCE = new UndertowSubsystemAdd();

    private UndertowSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : UndertowRootDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
    }

    public void performBoottime(OperationContext context, ModelNode operation, final ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final String defaultVirtualHost = UndertowRootDefinition.DEFAULT_VIRTUAL_HOST.resolveModelAttribute(context, model).asString();
        final String defaultContainer = UndertowRootDefinition.DEFAULT_SERVLET_CONTAINER.resolveModelAttribute(context, model).asString();
        final String defaultServer = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, model).asString();
        ModelNode instanceIdModel = UndertowRootDefinition.INSTANCE_ID.resolveModelAttribute(context, model);
        String instanceId = instanceIdModel.isDefined() ? instanceIdModel.asString() : null;
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(UndertowService.UNDERTOW, (Service)new UndertowService(defaultContainer, defaultServer, defaultVirtualHost, instanceId)).setInitialMode(ServiceController.Mode.ACTIVE).install());
        newControllers.add(target.addService(CommonWebServer.SERVICE_NAME, (Service)new WebServerService()).install());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                SharedWebMetaDataBuilder sharedWebBuilder = new SharedWebMetaDataBuilder(model.clone());
                SharedTldsMetaDataBuilder sharedTldsBuilder = new SharedTldsMetaDataBuilder(model.clone());
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2576, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(WebJBossAllParser.ROOT_ELEMENT, WebJBossAllParser.ATTACHMENT_KEY, (JBossAllXMLParser)new WebJBossAllParser()));
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2048, (DeploymentUnitProcessor)new WarDeploymentInitializingProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2304, (DeploymentUnitProcessor)new WarStructureDeploymentProcessor(sharedWebBuilder.create(), sharedTldsBuilder));
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 2816, (DeploymentUnitProcessor)new WebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3072, (DeploymentUnitProcessor)new WebFragmentParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3584, (DeploymentUnitProcessor)new JBossWebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3328, (DeploymentUnitProcessor)new WarAnnotationDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 4096, (DeploymentUnitProcessor)new EarContextRootProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8192, (DeploymentUnitProcessor)new WarMetaDataProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8193, (DeploymentUnitProcessor)new TldParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8194, (DeploymentUnitProcessor)new WebComponentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.DEPENDENCIES, 1792, (DeploymentUnitProcessor)new UndertowDependencyProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 11264, (DeploymentUnitProcessor)new ELExpressionFactoryProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 11776, (DeploymentUnitProcessor)new UndertowJSRWebSocketDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 12032, (DeploymentUnitProcessor)new UndertowHandlersDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 4864, (DeploymentUnitProcessor)new ServletContainerInitializerDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 7424, (DeploymentUnitProcessor)new UndertowDeploymentProcessor(defaultVirtualHost, defaultContainer, defaultServer));
            }
        }, OperationContext.Stage.RUNTIME);
        UndertowLogger.ROOT_LOGGER.serverStarting(Version.getVersionString());
        SessionManagerFactoryBuilder builder = new SessionManagerFactoryBuilderService().getValue();
        if (builder != null) {
            newControllers.add(builder.buildServerDependency(target, (Value)new ImmediateValue((Object)instanceId)).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        }
    }
}

