/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.vfs.VirtualFile;

public class ServletResourceManager
implements ResourceManager {
    private final FileResourceManager deploymentResourceManager;
    private final Collection<VirtualFile> overlays;

    public ServletResourceManager(VirtualFile resourcesRoot, Collection<VirtualFile> overlays) throws IOException {
        this.deploymentResourceManager = new FileResourceManager(resourcesRoot.getPhysicalFile());
        this.overlays = overlays;
    }

    public Resource getResource(String path) throws IOException {
        Resource res = this.deploymentResourceManager.getResource(path);
        if (res != null) {
            return res;
        }
        String p = path;
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (this.overlays != null) {
            for (VirtualFile overlay : this.overlays) {
                VirtualFile child = overlay.getChild(p);
                if (!child.exists()) continue;
                URL url = child.toURL();
                return new URLResource(url, url.openConnection(), path);
            }
        }
        return null;
    }
}

