/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.Handlers;
import io.undertow.jsp.JspFileWrapper;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.predicate.Predicate;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.JspPropertyGroup;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagFileInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.jasper.deploy.TagVariableInfo;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.InstanceManager;
import org.jboss.annotation.javaee.Icon;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.audit.AuditManager;
import org.jboss.vfs.VirtualFile;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.session.SessionManagerFacadeFactory;
import org.wildfly.extension.undertow.JSPService;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieConfigService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.JspConfigDescriptorImpl;
import org.wildfly.extension.undertow.deployment.JspInitializationListener;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.ServletResourceManager;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowJSPInstanceManager;
import org.wildfly.extension.undertow.security.AuditNotificationReceiver;
import org.wildfly.extension.undertow.security.JAASIdentityManagerImpl;
import org.wildfly.extension.undertow.security.SecurityContextAssociationHandler;
import org.wildfly.extension.undertow.security.SecurityContextCreationHandler;

public class UndertowDeploymentInfoService
implements Service<DeploymentInfo> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"UndertowDeploymentInfoService"});
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String HOME_DIR = "jboss.home.dir";
    private DeploymentInfo deploymentInfo;
    private final JBossWebMetaData mergedMetaData;
    private final String deploymentName;
    private final TldsMetaData tldsMetaData;
    private final List<TldMetaData> sharedTlds;
    private final Module module;
    private final WebInjectionContainer injectionContainer;
    private final ComponentRegistry componentRegistry;
    private final ScisMetaData scisMetaData;
    private final VirtualFile deploymentRoot;
    private final String securityContextId;
    private final String securityDomain;
    private final List<ServletContextAttribute> attributes;
    private final String contextPath;
    private final List<SetupAction> setupActions;
    private final Set<VirtualFile> overlays;
    private final List<ExpressionFactoryWrapper> expressionFactoryWrappers;
    private final List<PredicatedHandler> predicatedHandlers;
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final InjectedValue<SessionManagerFactory> sessionManagerFactory = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();
    private final InjectedValue<SessionCookieConfigService> defaultSessionCookieConfig = new InjectedValue();
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();

    private UndertowDeploymentInfoService(JBossWebMetaData mergedMetaData, String deploymentName, TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds, Module module, WebInjectionContainer injectionContainer, ComponentRegistry componentRegistry, ScisMetaData scisMetaData, VirtualFile deploymentRoot, String securityContextId, String securityDomain, List<ServletContextAttribute> attributes, String contextPath, List<SetupAction> setupActions, Set<VirtualFile> overlays, List<ExpressionFactoryWrapper> expressionFactoryWrappers, List<PredicatedHandler> predicatedHandlers) {
        this.mergedMetaData = mergedMetaData;
        this.deploymentName = deploymentName;
        this.tldsMetaData = tldsMetaData;
        this.sharedTlds = sharedTlds;
        this.module = module;
        this.injectionContainer = injectionContainer;
        this.componentRegistry = componentRegistry;
        this.scisMetaData = scisMetaData;
        this.deploymentRoot = deploymentRoot;
        this.securityContextId = securityContextId;
        this.securityDomain = securityDomain;
        this.attributes = attributes;
        this.contextPath = contextPath;
        this.setupActions = setupActions;
        this.overlays = overlays;
        this.expressionFactoryWrappers = expressionFactoryWrappers;
        this.predicatedHandlers = predicatedHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.module.getClassLoader());
            DeploymentInfo deploymentInfo = this.createServletConfig();
            this.handleDistributable(deploymentInfo);
            this.handleIdentityManager(deploymentInfo);
            SessionConfigMetaData sessionConfig = this.mergedMetaData.getSessionConfig();
            ServletSessionConfig config = null;
            SessionCookieConfigService defaultSessionConfig = (SessionCookieConfigService)this.defaultSessionCookieConfig.getOptionalValue();
            if (defaultSessionConfig != null) {
                config = new ServletSessionConfig();
                if (defaultSessionConfig.getName() != null) {
                    config.setName(defaultSessionConfig.getName());
                }
                if (defaultSessionConfig.getDomain() != null) {
                    config.setDomain(defaultSessionConfig.getDomain());
                }
                if (defaultSessionConfig.getHttpOnly() != null) {
                    config.setHttpOnly(defaultSessionConfig.getHttpOnly().booleanValue());
                }
                if (defaultSessionConfig.getSecure() != null) {
                    config.setSecure(defaultSessionConfig.getSecure().booleanValue());
                }
                if (defaultSessionConfig.getMaxAge() != null) {
                    config.setMaxAge(defaultSessionConfig.getMaxAge().intValue());
                }
                if (defaultSessionConfig.getComment() != null) {
                    config.setComment(defaultSessionConfig.getComment());
                }
            }
            if (sessionConfig != null) {
                List modes;
                if (sessionConfig.getSessionTimeoutSet()) {
                    deploymentInfo.setDefaultSessionTimeout(sessionConfig.getSessionTimeout() * 60);
                }
                CookieConfigMetaData cookieConfig = sessionConfig.getCookieConfig();
                if (config == null) {
                    config = new ServletSessionConfig();
                }
                if (cookieConfig != null) {
                    if (cookieConfig.getName() != null) {
                        config.setName(cookieConfig.getName());
                    }
                    if (cookieConfig.getDomain() != null) {
                        config.setDomain(cookieConfig.getDomain());
                    }
                    if (cookieConfig.getComment() != null) {
                        config.setComment(cookieConfig.getComment());
                    }
                    config.setSecure(cookieConfig.getSecure());
                    config.setPath(cookieConfig.getPath());
                    config.setMaxAge(cookieConfig.getMaxAge());
                    config.setHttpOnly(cookieConfig.getHttpOnly());
                }
                if ((modes = sessionConfig.getSessionTrackingModes()) != null && !modes.isEmpty()) {
                    HashSet<SessionTrackingMode> trackingModes = new HashSet<SessionTrackingMode>();
                    for (SessionTrackingModeType mode : modes) {
                        switch (mode) {
                            case COOKIE: {
                                trackingModes.add(SessionTrackingMode.COOKIE);
                                break;
                            }
                            case SSL: {
                                trackingModes.add(SessionTrackingMode.SSL);
                                break;
                            }
                            case URL: {
                                trackingModes.add(SessionTrackingMode.URL);
                            }
                        }
                    }
                    config.setSessionTrackingModes(trackingModes);
                }
            }
            if (config != null) {
                deploymentInfo.setServletSessionConfig(config);
            }
            for (final SetupAction action : this.setupActions) {
                deploymentInfo.addThreadSetupAction(new ThreadSetupAction(){
                    private final ThreadSetupAction.Handle handle = new ThreadSetupAction.Handle(){

                        public void tearDown() {
                            action.teardown(Collections.emptyMap());
                        }
                    };

                    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                        action.setup(Collections.emptyMap());
                        return this.handle;
                    }
                });
            }
            this.deploymentInfo = deploymentInfo;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        this.deploymentInfo.setConfidentialPortManager(null);
        this.deploymentInfo = null;
    }

    public synchronized DeploymentInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentInfo;
    }

    private void handleIdentityManager(DeploymentInfo deploymentInfo) {
        SecurityDomainContext sdc = (SecurityDomainContext)this.securityDomainContextValue.getValue();
        deploymentInfo.setIdentityManager((IdentityManager)new JAASIdentityManagerImpl(sdc, this.mergedMetaData.getPrincipalVersusRolesMap()));
        AuditManager auditManager = sdc.getAuditManager();
        if (auditManager != null && !this.mergedMetaData.isDisableAudit()) {
            deploymentInfo.addNotificationReceiver((NotificationReceiver)new AuditNotificationReceiver(auditManager));
        }
        deploymentInfo.setConfidentialPortManager(this.getConfidentialPortManager());
    }

    private ConfidentialPortManager getConfidentialPortManager() {
        return new ConfidentialPortManager(){

            public int getConfidentialPort(HttpServerExchange exchange) {
                return ((ServletContainerService)UndertowDeploymentInfoService.this.container.getValue()).lookupSecurePort("default");
            }
        };
    }

    private void handleDistributable(DeploymentInfo deploymentInfo) {
        SessionManagerFactory factory;
        if (this.mergedMetaData.getDistributable() != null && (factory = (SessionManagerFactory)this.sessionManagerFactory.getOptionalValue()) != null) {
            deploymentInfo.setSessionManagerFactory((io.undertow.servlet.api.SessionManagerFactory)new SessionManagerFacadeFactory(factory, this.mergedMetaData));
        }
    }

    private DeploymentInfo createServletConfig() throws StartException {
        try {
            LoginConfigMetaData loginConfig;
            ServletInfo jspServlet;
            if (!this.mergedMetaData.isMetadataComplete()) {
                this.mergedMetaData.resolveAnnotations();
            }
            DeploymentInfo d = new DeploymentInfo();
            d.setContextPath(this.contextPath);
            if (this.mergedMetaData.getDescriptionGroup() != null) {
                d.setDisplayName(this.mergedMetaData.getDescriptionGroup().getDisplayName());
            }
            d.setDeploymentName(this.deploymentName);
            try {
                ServletResourceManager resourceManager = new ServletResourceManager(this.deploymentRoot, this.overlays);
                d.setResourceManager((ResourceManager)new CachingResourceManager(100, 0xA00000L, (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue(), (ResourceManager)resourceManager, -1));
            }
            catch (IOException e) {
                throw new StartException((Throwable)e);
            }
            File tempFile = new File(((PathManager)this.pathManagerInjector.getValue()).getPathEntry(TEMP_DIR).resolvePath(), this.deploymentName);
            tempFile.mkdirs();
            d.setTempDir(tempFile);
            d.setClassLoader((ClassLoader)this.module.getClassLoader());
            String servletVersion = this.mergedMetaData.getServletVersion();
            if (servletVersion != null) {
                d.setMajorVersion(Integer.parseInt(servletVersion.charAt(0) + ""));
                d.setMinorVersion(Integer.parseInt(servletVersion.charAt(2) + ""));
            } else {
                d.setMajorVersion(3);
                d.setMinorVersion(1);
            }
            boolean is22OrOlder = d.getMajorVersion() == 1 ? true : (d.getMajorVersion() == 2 ? d.getMinorVersion() < 3 : false);
            JSPService jspService = (JSPService)((ServletContainerService)this.container.getValue()).getJspService().getOptionalValue();
            HashSet<String> seenMappings = new HashSet<String>();
            HashMap<String, TagLibraryInfo> tldInfo = UndertowDeploymentInfoService.createTldsInfo(this.tldsMetaData, this.sharedTlds);
            d.setDefaultServletConfig(new DefaultServletConfig(true, Collections.emptySet()));
            ServletInfo servletInfo = jspServlet = jspService != null ? jspService.getJSPServletInfo() : null;
            if (jspServlet != null) {
                HashMap<String, JspPropertyGroup> propertyGroups = UndertowDeploymentInfoService.createJspConfig(this.mergedMetaData);
                JspServletBuilder.setupDeployment((DeploymentInfo)d, propertyGroups, tldInfo, (InstanceManager)new UndertowJSPInstanceManager(this.injectionContainer));
                if (this.mergedMetaData.getJspConfig() != null) {
                    d.setJspConfigDescriptor((JspConfigDescriptor)new JspConfigDescriptorImpl(tldInfo.values(), propertyGroups.values()));
                }
                d.addServlet(jspServlet);
                Set<String> jspPropertyGroupMappings = propertyGroups.keySet();
                for (String mapping : jspPropertyGroupMappings) {
                    jspServlet.addMapping(mapping);
                }
                seenMappings.addAll(jspPropertyGroupMappings);
                if (!this.expressionFactoryWrappers.isEmpty()) {
                    d.addListener(new ListenerInfo(JspInitializationListener.class));
                    d.addServletContextAttribute("org.jboss.as.web.deployment.JspInitializationListener.wrappers", this.expressionFactoryWrappers);
                }
            }
            d.setClassIntrospecter((ClassIntrospecter)new ComponentClassIntrospector(this.componentRegistry));
            HashMap<String, ArrayList<ServletMappingMetaData>> servletMappings = new HashMap<String, ArrayList<ServletMappingMetaData>>();
            if (this.mergedMetaData.getServletMappings() != null) {
                for (ServletMappingMetaData mapping : this.mergedMetaData.getServletMappings()) {
                    ArrayList<ServletMappingMetaData> list = (ArrayList<ServletMappingMetaData>)servletMappings.get(mapping.getServletName());
                    if (list == null) {
                        list = new ArrayList<ServletMappingMetaData>();
                        servletMappings.put(mapping.getServletName(), list);
                    }
                    list.add(mapping);
                }
            }
            if (this.mergedMetaData.getServlets() != null) {
                for (JBossServletMetaData servlet : this.mergedMetaData.getServlets()) {
                    List mappings;
                    ServletInfo s;
                    if (servlet.getJspFile() != null) {
                        s = new ServletInfo(servlet.getName(), JspServlet.class);
                        s.addHandlerChainWrapper((HandlerWrapper)new JspFileWrapper(servlet.getJspFile()));
                    } else {
                        Class servletClass = this.module.getClassLoader().loadClass(servlet.getServletClass());
                        ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(servletClass);
                        if (creator != null) {
                            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                            s = new ServletInfo(servlet.getName(), servletClass, factory);
                        } else {
                            s = new ServletInfo(servlet.getName(), servletClass);
                        }
                    }
                    s.setAsyncSupported(servlet.isAsyncSupported()).setJspFile(servlet.getJspFile()).setEnabled(servlet.isEnabled());
                    if (servlet.getRunAs() != null) {
                        s.setRunAs(servlet.getRunAs().getRoleName());
                    }
                    if (servlet.getLoadOnStartupSet()) {
                        s.setLoadOnStartup(Integer.valueOf(servlet.getLoadOnStartupInt()));
                    }
                    if ((mappings = (List)servletMappings.get(servlet.getName())) != null) {
                        for (ServletMappingMetaData mapping : mappings) {
                            for (String pattern : mapping.getUrlPatterns()) {
                                if (is22OrOlder && !pattern.startsWith("*") && !pattern.startsWith("/")) {
                                    pattern = "/" + pattern;
                                }
                                if (seenMappings.contains(pattern)) continue;
                                s.addMapping(pattern);
                                seenMappings.add(pattern);
                            }
                        }
                    }
                    if (servlet.getInitParam() != null) {
                        for (ParamValueMetaData initParam : servlet.getInitParam()) {
                            if (s.getInitParams().containsKey(initParam.getParamName())) continue;
                            s.addInitParam(initParam.getParamName(), initParam.getParamValue());
                        }
                    }
                    if (servlet.getServletSecurity() != null) {
                        ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                        s.setServletSecurityInfo(securityInfo);
                        ((ServletSecurityInfo)((ServletSecurityInfo)securityInfo.setEmptyRoleSemantic(servlet.getServletSecurity().getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(servlet.getServletSecurity().getTransportGuarantee()))).addRolesAllowed((Collection)servlet.getServletSecurity().getRolesAllowed());
                        if (servlet.getServletSecurity().getHttpMethodConstraints() != null) {
                            for (HttpMethodConstraintMetaData method : servlet.getServletSecurity().getHttpMethodConstraints()) {
                                securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(method.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(method.getTransportGuarantee()))).addRolesAllowed((Collection)method.getRolesAllowed())).setMethod(method.getMethod()));
                            }
                        }
                    }
                    if (servlet.getSecurityRoleRefs() != null) {
                        for (SecurityRoleRefMetaData ref : servlet.getSecurityRoleRefs()) {
                            s.addSecurityRoleRef(ref.getRoleName(), ref.getRoleLink());
                        }
                    }
                    if (servlet.getMultipartConfig() != null) {
                        MultipartConfigMetaData mp = servlet.getMultipartConfig();
                        s.setMultipartConfig(Servlets.multipartConfig((String)mp.getLocation(), (long)mp.getMaxFileSize(), (long)mp.getMaxRequestSize(), (int)mp.getFileSizeThreshold()));
                    }
                    d.addServlet(s);
                }
            }
            if (this.mergedMetaData.getFilters() != null) {
                for (FilterMetaData filter : this.mergedMetaData.getFilters()) {
                    FilterInfo f;
                    Class filterClass = this.module.getClassLoader().loadClass(filter.getFilterClass());
                    ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(filterClass);
                    if (creator != null) {
                        InstanceFactory instanceFactory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                        f = new FilterInfo(filter.getName(), filterClass, instanceFactory);
                    } else {
                        f = new FilterInfo(filter.getName(), filterClass);
                    }
                    f.setAsyncSupported(filter.isAsyncSupported());
                    d.addFilter(f);
                    if (filter.getInitParam() == null) continue;
                    for (ParamValueMetaData initParam : filter.getInitParam()) {
                        f.addInitParam(initParam.getParamName(), initParam.getParamValue());
                    }
                }
            }
            if (this.mergedMetaData.getFilterMappings() != null) {
                for (ServletMappingMetaData mapping : this.mergedMetaData.getFilterMappings()) {
                    if (mapping.getUrlPatterns() != null) {
                        for (String url : mapping.getUrlPatterns()) {
                            if (is22OrOlder && !url.startsWith("*") && !url.startsWith("/")) {
                                url = "/" + url;
                            }
                            if (mapping.getDispatchers() != null && !mapping.getDispatchers().isEmpty()) {
                                for (DispatcherType dispatcher : mapping.getDispatchers()) {
                                    d.addFilterUrlMapping(mapping.getFilterName(), url, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                                }
                                continue;
                            }
                            d.addFilterUrlMapping(mapping.getFilterName(), url, javax.servlet.DispatcherType.REQUEST);
                        }
                    }
                    if (mapping.getServletNames() == null) continue;
                    for (String servletName : mapping.getServletNames()) {
                        if (mapping.getDispatchers() != null && !mapping.getDispatchers().isEmpty()) {
                            for (DispatcherType dispatcher : mapping.getDispatchers()) {
                                d.addFilterServletNameMapping(mapping.getFilterName(), servletName, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                            }
                            continue;
                        }
                        d.addFilterServletNameMapping(mapping.getFilterName(), servletName, javax.servlet.DispatcherType.REQUEST);
                    }
                }
            }
            if (this.scisMetaData != null && this.scisMetaData.getHandlesTypes() != null) {
                for (ServletContainerInitializer sci : this.scisMetaData.getScis()) {
                    ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory((Object)sci);
                    d.addServletContainerInitalizer(new ServletContainerInitializerInfo(sci.getClass(), (InstanceFactory)instanceFactory, this.scisMetaData.getHandlesTypes().get(sci)));
                }
            }
            if (this.mergedMetaData.getListeners() != null) {
                for (ListenerMetaData listener : this.mergedMetaData.getListeners()) {
                    UndertowDeploymentInfoService.addListener((ClassLoader)this.module.getClassLoader(), this.componentRegistry, d, listener);
                }
            }
            if (this.mergedMetaData.getContextParams() != null) {
                for (ParamValueMetaData param : this.mergedMetaData.getContextParams()) {
                    d.addInitParameter(param.getParamName(), param.getParamValue());
                }
            }
            if (this.mergedMetaData.getWelcomeFileList() != null && this.mergedMetaData.getWelcomeFileList().getWelcomeFiles() != null) {
                List welcomeFiles = this.mergedMetaData.getWelcomeFileList().getWelcomeFiles();
                for (String file : welcomeFiles) {
                    if (file.startsWith("/")) {
                        d.addWelcomePages(new String[]{file.substring(1)});
                        continue;
                    }
                    d.addWelcomePages(new String[]{file});
                }
            } else {
                d.addWelcomePages(new String[]{"index.html", "index.htm", "index.jsp"});
            }
            if (this.mergedMetaData.getErrorPages() != null) {
                for (ErrorPageMetaData page : this.mergedMetaData.getErrorPages()) {
                    ErrorPage errorPage = page.getExceptionType() != null && !page.getExceptionType().isEmpty() ? new ErrorPage(page.getLocation(), this.module.getClassLoader().loadClass(page.getExceptionType())) : (page.getErrorCode() != null && !page.getErrorCode().isEmpty() ? new ErrorPage(page.getLocation(), Integer.parseInt(page.getErrorCode())) : new ErrorPage(page.getLocation()));
                    d.addErrorPages(new ErrorPage[]{errorPage});
                }
            }
            if (this.mergedMetaData.getMimeMappings() != null) {
                for (ServletMappingMetaData mapping : this.mergedMetaData.getMimeMappings()) {
                    d.addMimeMapping(new MimeMapping(mapping.getExtension(), mapping.getMimeType()));
                }
            }
            d.setDenyUncoveredHttpMethods(this.mergedMetaData.getDenyUncoveredHttpMethods() != null);
            Set securityRoleNames = this.mergedMetaData.getSecurityRoleNames();
            if (this.mergedMetaData.getSecurityConstraints() != null) {
                for (SecurityConstraintMetaData constraint : this.mergedMetaData.getSecurityConstraints()) {
                    SecurityConstraint securityConstraint = (SecurityConstraint)new SecurityConstraint().setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(constraint.getTransportGuarantee()));
                    List roleNames = constraint.getRoleNames();
                    if (constraint.getAuthConstraint() == null) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                    } else if (roleNames.size() == 1 && roleNames.contains("*") && securityRoleNames.contains("*")) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                    } else {
                        securityConstraint.addRolesAllowed((Collection)roleNames);
                    }
                    if (constraint.getResourceCollections() != null) {
                        for (WebResourceCollectionMetaData resourceCollection : constraint.getResourceCollections()) {
                            securityConstraint.addWebResourceCollection(new WebResourceCollection().addHttpMethods((Collection)resourceCollection.getHttpMethods()).addHttpMethodOmissions((Collection)resourceCollection.getHttpMethodOmissions()).addUrlPatterns((Collection)resourceCollection.getUrlPatterns()));
                        }
                    }
                    d.addSecurityConstraint(securityConstraint);
                }
            }
            if ((loginConfig = this.mergedMetaData.getLoginConfig()) != null) {
                String authMethod = UndertowDeploymentInfoService.authMethod(loginConfig.getAuthMethod());
                if (loginConfig.getFormLoginConfig() != null) {
                    d.setLoginConfig(new LoginConfig(authMethod, loginConfig.getRealmName(), loginConfig.getFormLoginConfig().getLoginPage(), loginConfig.getFormLoginConfig().getErrorPage()));
                } else {
                    d.setLoginConfig(new LoginConfig(authMethod, loginConfig.getRealmName()));
                }
            }
            d.addSecurityRoles((Collection)this.mergedMetaData.getSecurityRoleNames());
            d.addOuterHandlerChainWrapper(SecurityContextCreationHandler.wrapper(this.securityDomain));
            d.addInnerHandlerChainWrapper(SecurityContextAssociationHandler.wrapper(this.mergedMetaData.getPrincipalVersusRolesMap(), this.mergedMetaData.getRunAsIdentity(), this.securityContextId));
            for (ServletContextAttribute attribute : this.attributes) {
                d.addServletContextAttribute(attribute.getName(), attribute.getValue());
            }
            if (this.mergedMetaData.getLocalEncodings() != null && this.mergedMetaData.getLocalEncodings().getMappings() != null) {
                for (LocaleEncodingMetaData locale : this.mergedMetaData.getLocalEncodings().getMappings()) {
                    d.addLocaleCharsetMapping(locale.getLocale(), locale.getEncoding());
                }
            }
            if (this.predicatedHandlers != null && !this.predicatedHandlers.isEmpty()) {
                d.addInitialHandlerChainWrapper(new HandlerWrapper(){

                    public HttpHandler wrap(HttpHandler handler) {
                        if (UndertowDeploymentInfoService.this.predicatedHandlers.size() == 1) {
                            PredicatedHandler ph = (PredicatedHandler)UndertowDeploymentInfoService.this.predicatedHandlers.get(0);
                            return Handlers.predicate((Predicate)ph.getPredicate(), (HttpHandler)ph.getHandler().wrap(handler), (HttpHandler)handler);
                        }
                        return Handlers.predicates((List)UndertowDeploymentInfoService.this.predicatedHandlers, (HttpHandler)handler);
                    }
                });
            }
            return d;
        }
        catch (ClassNotFoundException e) {
            throw new StartException((Throwable)e);
        }
    }

    private static String authMethod(String configuredMethod) {
        if (configuredMethod.equals("CLIENT-CERT")) {
            return "CLIENT_CERT";
        }
        return configuredMethod;
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    private static HashMap<String, JspPropertyGroup> createJspConfig(JBossWebMetaData metaData) {
        List groups;
        HashMap<String, JspPropertyGroup> result = new HashMap<String, JspPropertyGroup>();
        JspConfigMetaData config = metaData.getJspConfig();
        if (config != null && (groups = config.getPropertyGroups()) != null) {
            for (JspPropertyGroupMetaData group : groups) {
                JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                for (String pattern : group.getUrlPatterns()) {
                    jspPropertyGroup.addUrlPattern(pattern);
                }
                jspPropertyGroup.setElIgnored(group.getElIgnored());
                jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                jspPropertyGroup.setIsXml(group.getIsXml());
                if (group.getIncludePreludes() != null) {
                    for (String includePrelude : group.getIncludePreludes()) {
                        jspPropertyGroup.addIncludePrelude(includePrelude);
                    }
                }
                if (group.getIncludeCodas() != null) {
                    for (String includeCoda : group.getIncludeCodas()) {
                        jspPropertyGroup.addIncludeCoda(includeCoda);
                    }
                }
                jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                jspPropertyGroup.setBuffer(group.getBuffer());
                jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                for (String pattern : jspPropertyGroup.getUrlPatterns()) {
                    result.put(pattern, jspPropertyGroup);
                }
            }
        }
        LinkedHashMap<String, JspPropertyGroup> ret = new LinkedHashMap<String, JspPropertyGroup>();
        ArrayList paths = new ArrayList(result.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String path : paths) {
            ret.put(path, (JspPropertyGroup)result.get(path));
        }
        return ret;
    }

    private static HashMap<String, TagLibraryInfo> createTldsInfo(TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds) throws ClassNotFoundException {
        HashMap<String, TagLibraryInfo> ret = new HashMap<String, TagLibraryInfo>();
        if (tldsMetaData != null) {
            if (tldsMetaData.getTlds() != null) {
                for (Map.Entry<String, TldMetaData> tld : tldsMetaData.getTlds().entrySet()) {
                    UndertowDeploymentInfoService.createTldInfo(tld.getKey(), tld.getValue(), ret);
                }
            }
            if (sharedTlds != null) {
                for (TldMetaData metaData : sharedTlds) {
                    UndertowDeploymentInfoService.createTldInfo(null, metaData, ret);
                }
            }
        }
        return ret;
    }

    private static TagLibraryInfo createTldInfo(String location, TldMetaData tldMetaData, HashMap<String, TagLibraryInfo> ret) throws ClassNotFoundException {
        int pos;
        String relativeLocation = location;
        String jarPath = null;
        if (relativeLocation != null && relativeLocation.startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
            jarPath = relativeLocation.substring(pos);
            if (jarPath.startsWith("/")) {
                jarPath = jarPath.substring(1);
            }
            relativeLocation = relativeLocation.substring(0, pos);
        }
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                        tagAttributeInfo.setName(attributeMetaData.getName());
                        tagAttributeInfo.setType(attributeMetaData.getType());
                        tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                        tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                        tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            tagAttributeInfo.setDeferredValue("true");
                            tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            tagAttributeInfo.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            tagAttributeInfo.setDeferredMethod("true");
                            tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            tagAttributeInfo.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(tagAttributeInfo);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tagFileInfo = new TagFileInfo();
                tagFileInfo.setName(tagFileMetaData.getName());
                tagFileInfo.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tagFileInfo);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo functionInfo = new FunctionInfo();
                functionInfo.setName(functionMetaData.getName());
                functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(functionInfo);
            }
        }
        if (jarPath == null && relativeLocation == null) {
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
        } else if (jarPath == null) {
            tagLibraryInfo.setLocation("");
            tagLibraryInfo.setPath(relativeLocation);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            ret.put(relativeLocation, tagLibraryInfo);
        } else {
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            if (jarPath.equals("META-INF/taglib.tld")) {
                ret.put(relativeLocation, tagLibraryInfo);
            }
        }
        return tagLibraryInfo;
    }

    private static void addListener(ClassLoader classLoader, ComponentRegistry components, DeploymentInfo d, ListenerMetaData listener) throws ClassNotFoundException {
        ListenerInfo l;
        Class<?> listenerClass = classLoader.loadClass(listener.getListenerClass());
        ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)components.getComponentsByClass().get(listenerClass);
        if (creator != null) {
            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
            l = new ListenerInfo(listenerClass, factory);
        } else {
            l = new ListenerInfo(listenerClass);
        }
        d.addListener(l);
    }

    private static <T> InstanceFactory<T> createInstanceFactory(final ComponentRegistry.ComponentManagedReferenceFactory creator) {
        return new InstanceFactory<T>(){

            public InstanceHandle<T> createInstance() throws InstantiationException {
                final ManagedReference instance = creator.getReference();
                return new InstanceHandle<T>(){

                    public T getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextValue() {
        return this.securityDomainContextValue;
    }

    public Injector<SessionManagerFactory> getSessionManagerFactoryInjector() {
        return this.sessionManagerFactory;
    }

    public InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public InjectedValue<SessionCookieConfigService> getDefaultSessionCookieConfig() {
        return this.defaultSessionCookieConfig;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JBossWebMetaData mergedMetaData;
        private String deploymentName;
        private TldsMetaData tldsMetaData;
        private List<TldMetaData> sharedTlds;
        private Module module;
        private WebInjectionContainer injectionContainer;
        private ComponentRegistry componentRegistry;
        private ScisMetaData scisMetaData;
        private VirtualFile deploymentRoot;
        private String securityContextId;
        private List<ServletContextAttribute> attributes;
        private String contextPath;
        private String securityDomain;
        private List<SetupAction> setupActions;
        private Set<VirtualFile> overlays;
        private List<ExpressionFactoryWrapper> expressionFactoryWrappers;
        private List<PredicatedHandler> predicatedHandlers;

        Builder setMergedMetaData(JBossWebMetaData mergedMetaData) {
            this.mergedMetaData = mergedMetaData;
            return this;
        }

        public Builder setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder setTldsMetaData(TldsMetaData tldsMetaData) {
            this.tldsMetaData = tldsMetaData;
            return this;
        }

        public Builder setSharedTlds(List<TldMetaData> sharedTlds) {
            this.sharedTlds = sharedTlds;
            return this;
        }

        public Builder setModule(Module module) {
            this.module = module;
            return this;
        }

        public Builder setInjectionContainer(WebInjectionContainer injectionContainer) {
            this.injectionContainer = injectionContainer;
            return this;
        }

        public Builder setComponentRegistry(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
            return this;
        }

        public Builder setScisMetaData(ScisMetaData scisMetaData) {
            this.scisMetaData = scisMetaData;
            return this;
        }

        public Builder setDeploymentRoot(VirtualFile deploymentRoot) {
            this.deploymentRoot = deploymentRoot;
            return this;
        }

        public Builder setSecurityContextId(String securityContextId) {
            this.securityContextId = securityContextId;
            return this;
        }

        public Builder setAttributes(List<ServletContextAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSetupActions(List<SetupAction> setupActions) {
            this.setupActions = setupActions;
            return this;
        }

        public Builder setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setOverlays(Set<VirtualFile> overlays) {
            this.overlays = overlays;
            return this;
        }

        public Builder setExpressionFactoryWrappers(List<ExpressionFactoryWrapper> expressionFactoryWrappers) {
            this.expressionFactoryWrappers = expressionFactoryWrappers;
            return this;
        }

        public Builder setPredicatedHandlers(List<PredicatedHandler> predicatedHandlers) {
            this.predicatedHandlers = predicatedHandlers;
            return this;
        }

        public UndertowDeploymentInfoService createUndertowDeploymentInfoService() {
            return new UndertowDeploymentInfoService(this.mergedMetaData, this.deploymentName, this.tldsMetaData, this.sharedTlds, this.module, this.injectionContainer, this.componentRegistry, this.scisMetaData, this.deploymentRoot, this.securityContextId, this.securityDomain, this.attributes, this.contextPath, this.setupActions, this.overlays, this.expressionFactoryWrappers, this.predicatedHandlers);
        }
    }

    private static class ManagedReferenceInstanceFactory<T>
    implements InstanceFactory<T> {
        private final ComponentRegistry.ComponentManagedReferenceFactory component;

        public ManagedReferenceInstanceFactory(ComponentRegistry.ComponentManagedReferenceFactory component) {
            this.component = component;
        }

        public InstanceHandle<T> createInstance() throws InstantiationException {
            final ManagedReference reference = this.component.getReference();
            return new InstanceHandle<T>(){

                public T getInstance() {
                    return reference.getInstance();
                }

                public void release() {
                    reference.release();
                }
            };
        }
    }

    private static class ComponentClassIntrospector
    implements ClassIntrospecter {
        private final ComponentRegistry componentRegistry;

        public ComponentClassIntrospector(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
        }

        public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
            ComponentRegistry.ComponentManagedReferenceFactory component = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(clazz);
            if (component == null) {
                return new ConstructorInstanceFactory(clazz.getDeclaredConstructor(new Class[0]));
            }
            return new ManagedReferenceInstanceFactory(component);
        }
    }
}

