/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.Handler;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterService;

class FilterAdd
extends AbstractAddStepHandler {
    private Handler handler;

    FilterAdd(Handler handler) {
        super(handler.getAttributes());
        this.handler = handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        FilterService service = new FilterService(this.handler, this.getResolvedModel(context, model));
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(UndertowService.FILTER.append(new String[]{name}), (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    private ModelNode getResolvedModel(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode resolved = new ModelNode();
        for (AttributeDefinition attribute : this.attributes) {
            resolved.get(attribute.getName()).set(attribute.resolveModelAttribute(context, model));
        }
        return resolved;
    }
}

