/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpOpenListener;
import io.undertow.server.OpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.StartContext;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class AjpListenerService
extends AbstractListenerService<AjpListenerService> {
    private volatile AcceptingChannel<StreamConnection> server;
    private final String scheme;
    private final long maxUploadSize;

    public AjpListenerService(String name, String scheme, long maxUploadSize) {
        super(name);
        this.scheme = scheme;
        this.maxUploadSize = maxUploadSize;
    }

    @Override
    protected OpenListener createOpenListener() {
        AjpOpenListener ajpOpenListener = new AjpOpenListener((Pool)this.getBufferPool().getValue(), this.getBufferSize());
        ajpOpenListener.setScheme(this.scheme);
        return ajpOpenListener;
    }

    @Override
    void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        this.server = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, OptionMap.builder().addAll(SERVER_OPTIONS).set(UndertowOptions.MAX_ENTITY_SIZE, this.maxUploadSize).getMap());
        this.server.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("AJP", this.getName(), ((SocketBinding)this.binding.getValue()).getSocketAddress());
    }

    @Override
    void stopListening() {
        this.server.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("AJP", this.getName());
        IoUtils.safeClose(this.server);
        UndertowLogger.ROOT_LOGGER.listenerStopped("AJP", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
    }

    public AjpListenerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    protected void preStart(StartContext context) {
    }
}

