/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.websocket.ClientEndpoint;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.deployment.WebSocketContainerService;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class UndertowJSRWebSocketDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName SERVER_ENDPOINT = DotName.createSimple((String)ServerEndpoint.class.getName());
    private static final DotName CLIENT_ENDPOINT = DotName.createSimple((String)ClientEndpoint.class.getName());
    private static final DotName SERVER_APPLICATION_CONFIG = DotName.createSimple((String)ServerApplicationConfig.class.getName());
    private static final DotName ENDPOINT = DotName.createSimple((String)Endpoint.class.getName());
    public static final String FILTER_NAME = "Undertow Web Socket Filter";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Set epClasses;
            Set subclasses;
            Class moduleClass;
            List clientEndpoints;
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (metaData == null) {
                return;
            }
            HashSet annotatedEndpoints = new HashSet();
            HashSet<Class<? extends Endpoint>> endpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet<Class<? extends ServerApplicationConfig>> config = new HashSet<Class<? extends ServerApplicationConfig>>();
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List serverEndpoints = index.getAnnotations(SERVER_ENDPOINT);
            if (serverEndpoints != null) {
                for (AnnotationInstance endpoint : serverEndpoints) {
                    if (!(endpoint.target() instanceof ClassInfo)) continue;
                    ClassInfo clazz = (ClassInfo)endpoint.target();
                    try {
                        Class moduleClass2 = classIndex.classIndex(clazz.name().toString()).getModuleClass();
                        if (Modifier.isAbstract(moduleClass2.getModifiers())) continue;
                        annotatedEndpoints.add(moduleClass2);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketEndpoint(clazz.name().toString(), e);
                    }
                }
            }
            if ((clientEndpoints = index.getAnnotations(CLIENT_ENDPOINT)) != null) {
                for (AnnotationInstance endpoint : clientEndpoints) {
                    if (!(endpoint.target() instanceof ClassInfo)) continue;
                    ClassInfo clazz = (ClassInfo)endpoint.target();
                    try {
                        moduleClass = classIndex.classIndex(clazz.name().toString()).getModuleClass();
                        if (Modifier.isAbstract(moduleClass.getModifiers())) continue;
                        annotatedEndpoints.add(moduleClass);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketEndpoint(clazz.name().toString(), e);
                    }
                }
            }
            if ((subclasses = index.getAllKnownImplementors(SERVER_APPLICATION_CONFIG)) != null) {
                for (ClassInfo clazz : subclasses) {
                    try {
                        moduleClass = classIndex.classIndex(clazz.name().toString()).getModuleClass();
                        if (Modifier.isAbstract(moduleClass.getModifiers())) continue;
                        config.add(moduleClass);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketConfig(clazz.name().toString(), e);
                    }
                }
            }
            if ((epClasses = index.getAllKnownSubclasses(ENDPOINT)) != null) {
                for (ClassInfo clazz : epClasses) {
                    try {
                        Class moduleClass3 = classIndex.classIndex(clazz.name().toString()).getModuleClass();
                        if (Modifier.isAbstract(moduleClass3.getModifiers())) continue;
                        endpoints.add(moduleClass3);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketConfig(clazz.name().toString(), e);
                    }
                }
            }
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            this.doDeployment(webSocketDeploymentInfo, annotatedEndpoints, config, endpoints);
            this.installWebsockets(phaseContext, metaData, webSocketDeploymentInfo);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private void installWebsockets(DeploymentPhaseContext phaseContext, WarMetaData metaData, WebSocketDeploymentInfo webSocketDeploymentInfo) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        FiltersMetaData filters = metaData.getMergedJBossWebMetaData().getFilters();
        if (filters == null) {
            filters = new FiltersMetaData();
            metaData.getMergedJBossWebMetaData().setFilters(filters);
        }
        FilterMetaData filterMetaData = new FilterMetaData();
        filterMetaData.setAsyncSupported(true);
        filterMetaData.setFilterClass(JsrWebSocketFilter.class.getName());
        filterMetaData.setName(FILTER_NAME);
        filters.add((MappableMetaData)filterMetaData);
        ArrayList<FilterMappingMetaData> mappings = metaData.getMergedJBossWebMetaData().getFilterMappings();
        if (mappings == null) {
            mappings = new ArrayList<FilterMappingMetaData>();
            metaData.getMergedJBossWebMetaData().setFilterMappings(mappings);
        }
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName(FILTER_NAME);
        mapping.setDispatchers(Collections.singletonList(DispatcherType.REQUEST));
        mapping.setUrlPatterns(Collections.singletonList("/*"));
        mappings.add(mapping);
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute(ServerContainer.class.getName(), (Object)webSocketDeploymentInfo));
        ServiceName serviceName = deploymentUnit.getServiceName().append(WebSocketContainerService.SERVICE_NAME);
        WebSocketContainerService service = new WebSocketContainerService(webSocketDeploymentInfo);
        phaseContext.getServiceTarget().addService(serviceName, (Service)service).addDependency(IOServices.WORKER.append(new String[]{"default"}), XnioWorker.class, service.getXnioWorker()).addDependency(IOServices.BUFFER_POOL.append(new String[]{"default"}), Pool.class, service.getInjectedBuffer()).install();
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo));
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
        this.bindJndiServices(deploymentUnit, phaseContext.getServiceTarget(), moduleContextServiceName, serviceName, webSocketDeploymentInfo);
        deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)serviceName);
    }

    private void bindJndiServices(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName contextServiceName, ServiceName serviceName, WebSocketDeploymentInfo webSocketInfo) {
        ServiceName bindingServiceName = contextServiceName.append(new String[]{"ServerContainer"});
        final BinderService binderService = new BinderService("ServerContainer");
        serviceTarget.addService(bindingServiceName, (Service)binderService).addDependency(serviceName).addDependency(contextServiceName, ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).install();
        webSocketInfo.addListener(new WebSocketDeploymentInfo.ContainerReadyListener(){

            public void ready(ServerWebSocketContainer container) {
                binderService.getManagedObjectInjector().inject((Object)new ImmediateManagedReferenceFactory((Object)container));
            }
        });
        deploymentUnit.addToAttachmentList(Attachments.JNDI_DEPENDENCIES, (Object)bindingServiceName);
    }

    private void doDeployment(WebSocketDeploymentInfo container, Set<Class<?>> annotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverApplicationConfigClasses, Set<Class<? extends Endpoint>> endpoints) throws DeploymentUnitProcessingException {
        HashSet<Class<? extends Endpoint>> allScannedEndpointImplementations = new HashSet<Class<? extends Endpoint>>(endpoints);
        HashSet allScannedAnnotatedEndpoints = new HashSet(annotatedEndpoints);
        HashSet newAnnotatatedEndpoints = new HashSet();
        HashSet serverEndpointConfigurations = new HashSet();
        HashSet<ServerApplicationConfig> configInstances = new HashSet<ServerApplicationConfig>();
        for (Class<? extends ServerApplicationConfig> clazz : serverApplicationConfigClasses) {
            try {
                configInstances.add(clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                JsrWebSocketLogger.ROOT_LOGGER.couldNotInitializeConfiguration(clazz, (Throwable)e);
            }
        }
        if (!configInstances.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configInstances) {
                Set endpointConfigs;
                Set returnedEndpoints = serverApplicationConfig.getAnnotatedEndpointClasses(allScannedAnnotatedEndpoints);
                if (returnedEndpoints != null) {
                    newAnnotatatedEndpoints.addAll(returnedEndpoints);
                }
                if ((endpointConfigs = serverApplicationConfig.getEndpointConfigs(allScannedEndpointImplementations)) == null) continue;
                serverEndpointConfigurations.addAll(endpointConfigs);
            }
        } else {
            newAnnotatatedEndpoints.addAll(allScannedAnnotatedEndpoints);
        }
        for (Class<Object> clazz : newAnnotatatedEndpoints) {
            container.addEndpoint(clazz);
        }
        for (ServerEndpointConfig serverEndpointConfig : serverEndpointConfigurations) {
            container.addEndpoint(serverEndpointConfig);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

