/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import java.io.File;
import java.util.concurrent.Executor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.UndertowMessages;
import org.xnio.XnioWorker;

class AccessLogService
implements Service<AccessLogService> {
    protected final InjectedValue<XnioWorker> worker = new InjectedValue();
    private final String pattern;
    private final File directory;
    private final String filePrefix;
    private volatile AccessLogReceiver logReceiver;

    AccessLogService(String pattern, File directory, String filePrefix) {
        this.pattern = pattern;
        this.directory = directory;
        this.filePrefix = filePrefix;
    }

    public void start(StartContext context) throws StartException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw UndertowMessages.MESSAGES.couldNotCreateLogDirectory(this.directory);
        }
        try {
            this.logReceiver = new DefaultAccessLogReceiver((Executor)this.worker.getValue(), this.directory, this.filePrefix);
        }
        catch (IllegalStateException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
    }

    public AccessLogService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    protected AccessLogHandler configureAccessLogHandler(HttpHandler handler) {
        return new AccessLogHandler(handler, this.logReceiver, this.pattern, AccessLogHandler.class.getClassLoader());
    }
}

