/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.OptionList;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerRemoveHandler;
import org.wildfly.extension.undertow.UndertowExtension;

abstract class ListenerResourceDefinition
extends PersistentResourceDefinition {
    protected static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    protected static final SimpleAttributeDefinition WORKER = new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).setDefaultValue(new ModelNode("default")).build();
    protected static final SimpleAttributeDefinition BUFFER_POOL = new SimpleAttributeDefinitionBuilder("buffer-pool", ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).setDefaultValue(new ModelNode("default")).build();
    protected static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition REDIRECT_SOCKET = new SimpleAttributeDefinitionBuilder("redirect-socket", ModelType.STRING).setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode("https")).setAllowExpression(false).build();
    static final List<OptionAttributeDefinition> OPTIONS = OptionList.builder().addOption(UndertowOptions.MAX_HEADER_SIZE, "max-header-size", new ModelNode(51200)).addOption(UndertowOptions.MAX_ENTITY_SIZE, "max-post-size", new ModelNode(0xA00000L)).addOption(UndertowOptions.BUFFER_PIPELINED_DATA, "buffer-pipelined-data", new ModelNode(true)).addOption(UndertowOptions.MAX_PARAMETERS, "max-parameters", new ModelNode(1000)).addOption(UndertowOptions.MAX_HEADERS, "max-headers", new ModelNode(200)).addOption(UndertowOptions.MAX_COOKIES, "max-cookies", new ModelNode(200)).addOption(UndertowOptions.ALLOW_ENCODED_SLASH, "allow-encoded-slash", new ModelNode(false)).addOption(UndertowOptions.DECODE_URL, "decode-url", new ModelNode(true)).addOption(UndertowOptions.URL_CHARSET, "url-charset", new ModelNode("UTF-8")).addOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, "always-set-keep-alive", new ModelNode(true)).build();
    protected static final Collection ATTRIBUTES;
    protected static final List<AccessConstraintDefinition> CONSTRAINTS;

    public ListenerResourceDefinition(PathElement pathElement) {
        super(pathElement, (ResourceDescriptionResolver)UndertowExtension.getResolver("listener"));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        super.registerAddOperation(resourceRegistration, (AbstractAddStepHandler)this.getAddHandler(), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
        super.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ListenerRemoveHandler(this.getAddHandler()), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return CONSTRAINTS;
    }

    protected abstract ListenerAdd getAddHandler();

    static {
        CONSTRAINTS = Arrays.asList(UndertowExtension.LISTENER_CONSTRAINT);
        ATTRIBUTES = new LinkedHashSet<SimpleAttributeDefinition>(Arrays.asList(SOCKET_BINDING, WORKER, BUFFER_POOL, ENABLED));
        ATTRIBUTES.addAll(OPTIONS);
    }
}

