/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.SessionCookieConfig;

public class ServletContainerService
implements Service<ServletContainerService> {
    private final boolean allowNonStandardWrappers;
    private final ServletStackTraces stackTraces;
    private final SessionCookieConfig sessionCookieConfig;
    private final JSPConfig jspConfig;
    private volatile ServletContainer servletContainer;
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();
    private final InjectedValue<SessionPersistenceManager> sessionPersistenceManagerInjectedValue = new InjectedValue();
    private final String defaultEncoding;
    private final boolean useListenerEncoding;

    public ServletContainerService(boolean allowNonStandardWrappers, ServletStackTraces stackTraces, SessionCookieConfig sessionCookieConfig, JSPConfig jspConfig, String defaultEncoding, boolean useListenerEncoding) {
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.stackTraces = stackTraces;
        this.sessionCookieConfig = sessionCookieConfig;
        this.jspConfig = jspConfig;
        this.defaultEncoding = defaultEncoding;
        this.useListenerEncoding = useListenerEncoding;
    }

    public void start(StartContext context) throws StartException {
        this.servletContainer = ServletContainer.Factory.newInstance();
    }

    public void stop(StopContext context) {
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public boolean isAllowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public ServletStackTraces getStackTraces() {
        return this.stackTraces;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public DirectBufferCache getBufferCache() {
        return (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue();
    }

    InjectedValue<SessionPersistenceManager> getSessionPersistenceManagerInjectedValue() {
        return this.sessionPersistenceManagerInjectedValue;
    }

    public SessionPersistenceManager getSessionPersistenceManager() {
        return (SessionPersistenceManager)this.sessionPersistenceManagerInjectedValue.getOptionalValue();
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isUseListenerEncoding() {
        return this.useListenerEncoding;
    }
}

