/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

class SessionCookieDefinition
extends PersistentResourceDefinition {
    static final SessionCookieDefinition INSTANCE = new SessionCookieDefinition();
    protected static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition DOMAIN = new SimpleAttributeDefinitionBuilder("domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition COMMENT = new SimpleAttributeDefinitionBuilder("comment", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition HTTP_ONLY = new SimpleAttributeDefinitionBuilder("http-only", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition SECURE = new SimpleAttributeDefinitionBuilder("secure", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition MAX_AGE = new SimpleAttributeDefinitionBuilder("max-age", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{NAME, DOMAIN, COMMENT, HTTP_ONLY, SECURE, MAX_AGE};
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();

    private SessionCookieDefinition() {
        super(UndertowExtension.PATH_SESSION_COOKIE, (ResourceDescriptionResolver)UndertowExtension.getResolver(UndertowExtension.PATH_SESSION_COOKIE.getKeyValuePair()), (OperationStepHandler)new SessionCookieAdd(), (OperationStepHandler)new SessionCookieRemove());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public SessionCookieConfig getConfig(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        ModelNode nameValue = NAME.resolveModelAttribute(context, model);
        ModelNode domainValue = DOMAIN.resolveModelAttribute(context, model);
        ModelNode commentValue = COMMENT.resolveModelAttribute(context, model);
        ModelNode secureValue = SECURE.resolveModelAttribute(context, model);
        ModelNode httpOnlyValue = HTTP_ONLY.resolveModelAttribute(context, model);
        ModelNode maxAgeValue = MAX_AGE.resolveModelAttribute(context, model);
        String name = nameValue.isDefined() ? nameValue.asString() : null;
        String domain = domainValue.isDefined() ? domainValue.asString() : null;
        String comment = commentValue.isDefined() ? commentValue.asString() : null;
        Boolean secure = secureValue.isDefined() ? Boolean.valueOf(secureValue.asBoolean()) : null;
        Boolean httpOnly = httpOnlyValue.isDefined() ? Boolean.valueOf(httpOnlyValue.asBoolean()) : null;
        Integer maxAge = maxAgeValue.isDefined() ? Integer.valueOf(maxAgeValue.asInt()) : null;
        return new SessionCookieConfig(name, domain, comment, httpOnly, secure, maxAge);
    }

    static {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
    }

    private static class SessionCookieRemove
    extends RestartParentResourceRemoveHandler {
        protected SessionCookieRemove() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, null, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }

    private static class SessionCookieAdd
    extends RestartParentResourceAddHandler {
        protected SessionCookieAdd() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (SimpleAttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, null, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }
}

