/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.Version;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.EventInvoker;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowLogger;

public class UndertowService
implements Service<UndertowService> {
    public static final ServiceName UNDERTOW = ServiceName.JBOSS.append(new String[]{"undertow"});
    public static final ServiceName SERVLET_CONTAINER = UNDERTOW.append(new String[]{"servlet-container"});
    public static final ServiceName SERVER = UNDERTOW.append(new String[]{"server"});
    public static final ServiceName HANDLER = UNDERTOW.append(new String[]{"handler"});
    public static final ServiceName FILTER = UNDERTOW.append(new String[]{"filter"});
    static final ServiceName WEB_DEPLOYMENT_BASE = UNDERTOW.append(new String[]{"deployment"});
    private final String defaultContainer;
    private final String defaultServer;
    private final String defaultVirtualHost;
    private final Set<Server> registeredServers = new CopyOnWriteArraySet<Server>();
    private final List<UndertowEventListener> listeners = new CopyOnWriteArrayList<UndertowEventListener>();
    private volatile String instanceId;

    protected UndertowService(String defaultContainer, String defaultServer, String defaultVirtualHost, String instanceId) {
        this.defaultContainer = defaultContainer;
        this.defaultServer = defaultServer;
        this.defaultVirtualHost = defaultVirtualHost;
        this.instanceId = instanceId;
    }

    public static ServiceName deploymentServiceName(String serverName, String virtualHost, String contextPath) {
        return WEB_DEPLOYMENT_BASE.append(new String[]{serverName}).append(new String[]{virtualHost}).append(new String[]{"".equals(contextPath) ? "/" : contextPath});
    }

    public static ServiceName virtualHostName(String server, String virtualHost) {
        return SERVER.append(new String[]{server}).append(new String[]{virtualHost});
    }

    public static ServiceName locationServiceName(String server, String virtualHost, String locationName) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"location", locationName});
    }

    public static ServiceName accessLogServiceName(String server, String virtualHost) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"access-log"});
    }

    public static ServiceName consoleRedirectServiceName(String server, String virtualHost) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"console", "redirect"});
    }

    public static ServiceName listenerName(String listenerName) {
        return UNDERTOW.append(new String[]{"listener"}).append(new String[]{listenerName});
    }

    public void start(StartContext context) throws StartException {
        UndertowLogger.ROOT_LOGGER.serverStarting(Version.getVersionString());
    }

    public void stop(StopContext context) {
        UndertowLogger.ROOT_LOGGER.serverStopping(Version.getVersionString());
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onShutdown();
            }
        });
    }

    public UndertowService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected void registerServer(final Server server) {
        this.registeredServers.add(server);
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onServerStart(server);
            }
        });
    }

    protected void unregisterServer(final Server server) {
        this.registeredServers.remove(server);
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onServerStop(server);
            }
        });
    }

    public String getDefaultContainer() {
        return this.defaultContainer;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public String getDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.registeredServers);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void registerListener(UndertowEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(UndertowEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(EventInvoker invoker) {
        for (UndertowEventListener listener : this.listeners) {
            invoker.invoke(listener);
        }
    }
}

