/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowMessages;

class WebServerService
implements CommonWebServer,
Service<WebServerService> {
    private InjectedValue<Server> serverInjectedValue = new InjectedValue();

    WebServerService() {
    }

    InjectedValue<Server> getServerInjectedValue() {
        return this.serverInjectedValue;
    }

    public int getPort(String protocol, boolean secure) {
        Map<String, ListenerService> listeners = this.getListenerMap();
        ListenerService listener = null;
        for (String p : listeners.keySet()) {
            if (!protocol.toLowerCase().contains(p)) continue;
            listener = listeners.get(p);
        }
        if (listener != null && listener.getProtocol() == "http" && secure) {
            if (listeners.containsKey("https")) {
                listener = listeners.get("https");
            } else {
                UndertowLogger.ROOT_LOGGER.secureListenerNotAvailableForPort(protocol);
            }
        }
        if (listener != null) {
            SocketBinding binding = (SocketBinding)listener.getBinding().getValue();
            return binding.getAbsolutePort();
        }
        throw UndertowMessages.MESSAGES.noPortListeningForProtocol(protocol);
    }

    private Map<String, ListenerService> getListenerMap() {
        HashMap<String, ListenerService> listeners = new HashMap<String, ListenerService>();
        for (ListenerService<?> listener : ((Server)this.serverInjectedValue.getValue()).getListeners()) {
            listeners.put(listener.getProtocol(), listener);
        }
        return listeners;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WebServerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

