/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.security.SecurityActions;

public class RunAsLifecycleInterceptor
implements LifecycleInterceptor {
    private final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap;

    public RunAsLifecycleInterceptor(Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap) {
        this.runAsIdentityMetaDataMap = runAsIdentityMetaDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle(ServletInfo servletInfo, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        RunAsIdentityMetaData identity = null;
        RunAs old = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            context.proceed();
            return;
        }
        try {
            identity = this.runAsIdentityMetaDataMap.get(servletInfo.getName());
            RunAsIdentity runAsIdentity = null;
            if (identity != null) {
                UndertowLogger.ROOT_LOGGER.tracef("%s, runAs: %s", servletInfo.getName(), identity);
                runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
            }
            old = SecurityActions.setRunAsIdentity(runAsIdentity, sc);
            context.proceed();
            if (identity == null) return;
        }
        catch (Throwable throwable) {
            if (identity == null) throw throwable;
            SecurityActions.setRunAsIdentity(old, sc);
            throw throwable;
        }
        SecurityActions.setRunAsIdentity(old, sc);
    }

    public void init(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        if (servletInfo.getRunAs() != null) {
            this.handle(servletInfo, context);
        } else {
            context.proceed();
        }
    }

    public void init(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        context.proceed();
    }

    public void destroy(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        this.handle(servletInfo, context);
    }

    public void destroy(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
        context.proceed();
    }
}

