/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextThreadSetupAction
implements ThreadSetupAction {
    private final String securityDomain;
    private final SecurityDomainContext securityDomainContext;
    private final Map<String, Set<String>> principleVsRoleMap;
    private static final ThreadSetupAction.Handle TEAR_DOWN_ACTION = new ThreadSetupAction.Handle(){

        public void tearDown() {
            if (WildFlySecurityManager.isChecking()) {
                WildFlySecurityManager.doUnchecked((PrivilegedAction)TEAR_DOWN_PA);
            } else {
                SecurityActions.clearSecurityContext();
                SecurityRolesAssociation.setSecurityRoles(null);
            }
        }
    };
    private static final PrivilegedAction<Object> TEAR_DOWN_PA = new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            SecurityActions.clearSecurityContext();
            SecurityRolesAssociation.setSecurityRoles(null);
            return null;
        }
    };

    public SecurityContextThreadSetupAction(String securityDomain, SecurityDomainContext securityDomainContext, Map<String, Set<String>> principleVsRoleMap) {
        this.securityDomain = securityDomain;
        this.securityDomainContext = securityDomainContext;
        this.principleVsRoleMap = principleVsRoleMap;
    }

    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        if (exchange == null) {
            return null;
        }
        SecurityContext sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
        if (sc == null) {
            sc = SecurityActions.createSecurityContext(this.securityDomain);
            exchange.putAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT, (Object)sc);
        }
        SecurityActions.setSecurityContextOnAssociation(sc);
        final MappingManager mappingManager = this.securityDomainContext.getMappingManager();
        if (mappingManager != null) {
            if (WildFlySecurityManager.isChecking()) {
                WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        MappingContext mc = mappingManager.getMappingContext(MappingType.ROLE.name());
                        if (mc != null && mc.hasModules()) {
                            SecurityRolesAssociation.setSecurityRoles((Map)SecurityContextThreadSetupAction.this.principleVsRoleMap);
                        }
                        return null;
                    }
                });
            } else {
                MappingContext mc = mappingManager.getMappingContext(MappingType.ROLE.name());
                if (mc != null && mc.hasModules()) {
                    SecurityRolesAssociation.setSecurityRoles(this.principleVsRoleMap);
                }
            }
        }
        return TEAR_DOWN_ACTION;
    }
}

