/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.filters.FilterRef;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class LocationService
implements Service<LocationService> {
    private final String locationPath;
    private final InjectedValue<HttpHandler> httpHandler = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final CopyOnWriteArrayList<InjectedValue<FilterRef>> filters = new CopyOnWriteArrayList();

    public LocationService(String locationPath) {
        this.locationPath = locationPath;
    }

    public void start(StartContext context) throws StartException {
        UndertowLogger.ROOT_LOGGER.tracef("registering handler %s under path '%s'", this.httpHandler.getValue(), this.locationPath);
        ((Host)this.host.getValue()).registerHandler(this.locationPath, this.configureHandler());
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).unregisterHandler(this.locationPath);
    }

    public LocationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    InjectedValue<Host> getHost() {
        return this.host;
    }

    InjectedValue<HttpHandler> getHttpHandler() {
        return this.httpHandler;
    }

    List<InjectedValue<FilterRef>> getFilters() {
        return this.filters;
    }

    private HttpHandler configureHandler() {
        ArrayList<FilterRef> filters = new ArrayList<FilterRef>(this.filters.size());
        for (InjectedValue<FilterRef> injectedFilter : this.filters) {
            filters.add((FilterRef)((Object)injectedFilter.getValue()));
        }
        return LocationService.configureHandlerChain((HttpHandler)this.getHttpHandler().getValue(), filters);
    }

    protected static HttpHandler configureHandlerChain(HttpHandler rootHandler, List<FilterRef> filters) {
        Collections.sort(filters, new Comparator<FilterRef>(){

            @Override
            public int compare(FilterRef o1, FilterRef o2) {
                return o1.getPriority() >= o2.getPriority() ? 1 : -1;
            }
        });
        Collections.reverse(filters);
        HttpHandler handler = rootHandler;
        for (FilterRef filter : filters) {
            handler = filter.createHttpHandler(handler);
        }
        return handler;
    }
}

