/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.wasm.Capabilities;
import org.wildfly.extension.wasm.WasmProviderRegistrar;
import org.wildfly.extension.wasm.injection.WasmToolConfiguration;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class WasmProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String path = WasmProviderRegistrar.WASM_PATH.resolveModelAttribute(context, model).asString();
        final String relativeTo = WasmProviderRegistrar.WASM_RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
        final String name = context.getCurrentAddressValue();
        final ServiceDependency pathManager = ServiceDependency.on((NullaryServiceDescriptor)PathManager.SERVICE_DESCRIPTOR);
        Supplier<WasmToolConfiguration> factory = new Supplier<WasmToolConfiguration>(){

            @Override
            public WasmToolConfiguration get() {
                Path wasmFile = new File(((PathManager)pathManager.get()).resolveRelativePathEntry(path, relativeTo)).toPath();
                return new WasmToolConfiguration(name, wasmFile, Collections.emptyMap());
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.WASM_TOOL_PROVIDER_CAPABILITY, (Supplier)factory).requires((Consumer)pathManager)).asActive()).build();
    }
}

