/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.services.bootstrap.ManagedReferenceFactoryToResourceReferenceFactoryAdapter;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractResourceInjectionServices {
    protected final ServiceRegistry serviceRegistry;
    protected final EEModuleDescription moduleDescription;
    private final Module module;
    private static final Map<Class<?>, Class<?>> BOXED_TYPES;

    protected AbstractResourceInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, Module module) {
        this.serviceRegistry = serviceRegistry;
        this.moduleDescription = moduleDescription;
        this.module = module;
    }

    protected abstract ContextNames.BindInfo getBindInfo(String var1);

    protected ManagedReferenceFactory getManagedReferenceFactory(ContextNames.BindInfo ejbBindInfo) {
        try {
            ServiceController controller = this.serviceRegistry.getRequiredService(ejbBindInfo.getBinderServiceName());
            return (ManagedReferenceFactory)controller.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ResourceReferenceFactory<Object> handleServiceLookup(String result, InjectionPoint injectionPoint) {
        ContextNames.BindInfo ejbBindInfo = this.getBindInfo(result);
        ManagedReferenceFactory factory = this.getManagedReferenceFactory(ejbBindInfo);
        this.validateResourceInjectionPointType(factory, injectionPoint);
        if (factory != null) {
            return new ManagedReferenceFactoryToResourceReferenceFactoryAdapter<Object>(factory);
        }
        return this.createLazyResourceReferenceFactory(ejbBindInfo);
    }

    protected void validateResourceInjectionPointType(ManagedReferenceFactory fact, InjectionPoint injectionPoint) {
        if (!(fact instanceof ContextListManagedReferenceFactory) || injectionPoint == null) {
            return;
        }
        ContextListManagedReferenceFactory factory = (ContextListManagedReferenceFactory)fact;
        Class resourceClass = org.jboss.as.weld.util.Reflections.loadClass(factory.getInstanceClassName(), factory.getClass().getClassLoader());
        if (resourceClass == null) {
            resourceClass = org.jboss.as.weld.util.Reflections.loadClass(factory.getInstanceClassName(), (ClassLoader)this.module.getClassLoader());
        }
        if (resourceClass != null) {
            AbstractResourceInjectionServices.validateResourceInjectionPointType(resourceClass, injectionPoint);
        }
    }

    protected static void validateResourceInjectionPointType(Class<?> resourceType, InjectionPoint injectionPoint) {
        Class injectionPointRawType = Reflections.getRawType((Type)injectionPoint.getType());
        HierarchyDiscovery discovery = new HierarchyDiscovery(resourceType);
        for (Type type : discovery.getTypeClosure()) {
            if (!Reflections.getRawType((Type)type).equals(injectionPointRawType)) continue;
            return;
        }
        if (resourceType.isPrimitive() && BOXED_TYPES.get(resourceType).equals(injectionPointRawType)) {
            return;
        }
        if (injectionPointRawType.isPrimitive() && BOXED_TYPES.get(injectionPointRawType).equals(resourceType)) {
            return;
        }
        throw BeanLogger.LOG.invalidResourceProducerType((Object)injectionPoint.getAnnotated(), (Object)resourceType.getName());
    }

    protected ResourceReferenceFactory<Object> createLazyResourceReferenceFactory(final ContextNames.BindInfo ejbBindInfo) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                ManagedReferenceFactory factory = AbstractResourceInjectionServices.this.getManagedReferenceFactory(ejbBindInfo);
                if (factory == null) {
                    return new SimpleResourceReference(null);
                }
                final ManagedReference instance = factory.getReference();
                return new ResourceReference<Object>(){

                    public Object getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }

    static {
        HashMap<Class<Serializable>, Class> types = new HashMap<Class<Serializable>, Class>();
        types.put(Integer.TYPE, Integer.class);
        types.put(Byte.TYPE, Byte.class);
        types.put(Short.TYPE, Short.class);
        types.put(Long.TYPE, Long.class);
        types.put(Character.TYPE, Character.class);
        types.put(Float.TYPE, Float.class);
        types.put(Double.TYPE, Double.class);
        types.put(Boolean.TYPE, Boolean.class);
        BOXED_TYPES = Collections.unmodifiableMap(types);
    }
}

