/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class WeldDependencyProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static ModuleIdentifier JBOSS_AS_WELD_ID = ModuleIdentifier.create((String)"org.jboss.as.weld");
    private static ModuleIdentifier WELD_CORE_ID = ModuleIdentifier.create((String)"org.jboss.weld.core");
    private static ModuleIdentifier WELD_API_ID = ModuleIdentifier.create((String)"org.jboss.weld.api");
    private static ModuleIdentifier WELD_SPI_ID = ModuleIdentifier.create((String)"org.jboss.weld.spi");
    private static ModuleIdentifier CDI_BEAN_VALIDATION_ID = ModuleIdentifier.create((String)"org.hibernate.validator.cdi");
    private static ModuleIdentifier JAVAX_ENTERPRISE_API = ModuleIdentifier.create((String)"javax.enterprise.api");
    private static ModuleIdentifier JAVAX_INJECT_API = ModuleIdentifier.create((String)"javax.inject.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_ENTERPRISE_API);
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_INJECT_API);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_PERSISTENCE_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_CORE_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, WELD_SPI_ID);
        ModuleDependency dep = new ModuleDependency(moduleLoader, JBOSS_AS_WELD_ID, false, false, false, false);
        dep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        dep.addImportFilter(PathFilters.is((String)"org/jboss/as/weld/ejb"), true);
        dep.addImportFilter(PathFilters.is((String)"org/jboss/as/weld/injection"), true);
        dep.addImportFilter(PathFilters.acceptAll(), false);
        dep.addExportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(dep);
        ModuleDependency cdiBeanValidationDep = new ModuleDependency(moduleLoader, CDI_BEAN_VALIDATION_ID, false, false, true, false);
        moduleSpecification.addSystemDependency(cdiBeanValidationDep);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

