/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentFactory;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.deployment.WeldClassIntrospector;
import org.jboss.as.weld.ejb.EjbRequestScopeActivationInterceptor;
import org.jboss.as.weld.ejb.WeldInterceptorBindingsService;
import org.jboss.as.weld.injection.WeldComponentService;
import org.jboss.as.weld.injection.WeldConstructionStartInterceptor;
import org.jboss.as.weld.injection.WeldInjectionContextInterceptor;
import org.jboss.as.weld.injection.WeldInjectionInterceptor;
import org.jboss.as.weld.injection.WeldInterceptorInjectionInterceptor;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.as.weld.interceptors.Jsr299BindingsCreateInterceptor;
import org.jboss.as.weld.interceptors.Jsr299BindingsInterceptor;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.spi.ComponentIntegrator;
import org.jboss.as.weld.spi.ComponentInterceptorSupport;
import org.jboss.as.weld.util.ServiceLoaders;
import org.jboss.as.weld.util.Utils;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldComponentIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit topLevelDeployment = Utils.getRootDeploymentUnit(deploymentUnit);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        final ServiceName weldBootstrapService = topLevelDeployment.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        final ServiceName weldStartService = topLevelDeployment.getServiceName().append(WeldStartService.SERVICE_NAME);
        final ServiceName beanManagerService = ServiceNames.beanManagerServiceName((DeploymentUnit)deploymentUnit);
        final ServiceLoader<ComponentIntegrator> componentIntegrators = ServiceLoader.load(ComponentIntegrator.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldComponentIntegrationProcessor.class));
        final ComponentInterceptorSupport componentInterceptorSupport = ServiceLoaders.loadSingle(ComponentInterceptorSupport.class, WeldComponentIntegrationProcessor.class).orElse(null);
        WeldClassIntrospector.install(deploymentUnit, phaseContext.getServiceTarget());
        eeModuleDescription.setDefaultClassIntrospectorServiceName(WeldClassIntrospector.serviceName(deploymentUnit));
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            final String beanName = this.isBeanNameRequired(component, componentIntegrators) ? component.getComponentName() : null;
            component.getConfigurators().add((context, description, configuration) -> {
                EjbRequestScopeActivationInterceptor.Factory requestFactory = new EjbRequestScopeActivationInterceptor.Factory(beanManagerService);
                for (ViewConfiguration view : configuration.getViews()) {
                    view.addViewInterceptor((InterceptorFactory)requestFactory, 1152);
                }
                configuration.addTimeoutViewInterceptor((InterceptorFactory)requestFactory, 1152);
            });
            component.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    Class componentClass = configuration.getComponentClass();
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                    ModuleClassLoader classLoader = module.getClassLoader();
                    HashSet<Class> interceptorClasses = new HashSet<Class>();
                    for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                        try {
                            interceptorClasses.add(ClassLoadingUtils.loadClass((String)interceptorDescription.getInterceptorClassName(), (Module)module));
                        }
                        catch (ClassNotFoundException e) {
                            throw WeldLogger.ROOT_LOGGER.couldNotLoadInterceptorClass(interceptorDescription.getInterceptorClassName(), (Throwable)e);
                        }
                    }
                    WeldComponentIntegrationProcessor.this.addWeldIntegration(componentIntegrators, componentInterceptorSupport, context.getServiceTarget(), configuration, description, componentClass, beanName, weldBootstrapService, weldStartService, beanManagerService, interceptorClasses, (ClassLoader)classLoader, description.getBeanDeploymentArchiveId());
                }
            });
        }
    }

    private boolean isBeanNameRequired(ComponentDescription component, Iterable<ComponentIntegrator> integrators) {
        for (ComponentIntegrator integrator : integrators) {
            if (!integrator.isBeanNameRequired(component)) continue;
            return true;
        }
        return false;
    }

    private boolean isComponentWithView(ComponentDescription component, Iterable<ComponentIntegrator> integrators) {
        for (ComponentIntegrator integrator : integrators) {
            if (!integrator.isComponentWithView(component)) continue;
            return true;
        }
        return false;
    }

    private void addWeldIntegration(Iterable<ComponentIntegrator> componentIntegrators, ComponentInterceptorSupport componentInterceptorSupport, ServiceTarget target, ComponentConfiguration configuration, ComponentDescription description, Class<?> componentClass, String beanName, ServiceName weldServiceName, ServiceName weldStartService, ServiceName beanManagerService, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        final ServiceName serviceName = configuration.getComponentDescription().getServiceName().append(new String[]{"WeldInstantiator"});
        ServiceBuilder builder = target.addService(serviceName);
        builder.requires(weldStartService);
        configuration.setInstanceFactory((ComponentFactory)WeldManagedReferenceFactory.INSTANCE);
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                serviceBuilder.requires(serviceName);
            }
        });
        boolean isComponentIntegrationPerformed = false;
        for (ComponentIntegrator componentIntegrator : componentIntegrators) {
            ComponentIntegrator.DefaultInterceptorIntegrationAction integrationAction;
            Supplier<ServiceName> bindingServiceNameSupplier;
            if (!componentIntegrator.integrate(beanManagerService, configuration, description, builder, bindingServiceNameSupplier = () -> {
                if (componentInterceptorSupport == null) {
                    throw WeldLogger.DEPLOYMENT_LOGGER.componentInterceptorSupportNotAvailable((Object)componentClass);
                }
                return WeldComponentIntegrationProcessor.addWeldInterceptorBindingService(target, configuration, componentClass, beanName, weldServiceName, weldStartService, beanDeploymentArchiveId, componentInterceptorSupport);
            }, integrationAction = bindingServiceName -> {
                if (componentInterceptorSupport == null) {
                    throw WeldLogger.DEPLOYMENT_LOGGER.componentInterceptorSupportNotAvailable((Object)componentClass);
                }
                WeldComponentIntegrationProcessor.addJsr299BindingsCreateInterceptor(configuration, description, beanName, weldServiceName, builder, bindingServiceName, componentInterceptorSupport);
                WeldComponentIntegrationProcessor.addCommonLifecycleInterceptionSupport(configuration, builder, bindingServiceName, beanManagerService, componentInterceptorSupport);
                configuration.addComponentInterceptor((InterceptorFactory)new UserInterceptorFactory(Jsr299BindingsInterceptor.factory((InterceptionType)InterceptionType.AROUND_INVOKE, (ServiceBuilder)builder, (ServiceName)bindingServiceName, (ComponentInterceptorSupport)componentInterceptorSupport), Jsr299BindingsInterceptor.factory((InterceptionType)InterceptionType.AROUND_TIMEOUT, (ServiceBuilder)builder, (ServiceName)bindingServiceName, (ComponentInterceptorSupport)componentInterceptorSupport)), 2816, false);
            }, componentInterceptorSupport)) continue;
            isComponentIntegrationPerformed = true;
            break;
        }
        Supplier weldContainerSupplier = builder.requires(weldServiceName);
        final WeldComponentService weldComponentService = new WeldComponentService(weldContainerSupplier, componentClass, beanName, interceptorClasses, classLoader, beanDeploymentArchiveId, description.isCDIInterceptorEnabled(), description, this.isComponentWithView(description, componentIntegrators));
        builder.setInstance((Service)weldComponentService);
        if (!isComponentIntegrationPerformed) {
            description.setIgnoreLifecycleInterceptors(true);
            configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new AbstractInjectionTargetDelegatingInterceptor(){

                @Override
                protected void run(Object instance) {
                    weldComponentService.getInjectionTarget().postConstruct(instance);
                }
            }), 4096);
            configuration.addPreDestroyInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new AbstractInjectionTargetDelegatingInterceptor(){

                @Override
                protected void run(Object instance) {
                    weldComponentService.getInjectionTarget().preDestroy(instance);
                }
            }), 2816);
        }
        builder.install();
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new WeldInjectionContextInterceptor(weldComponentService)), 768);
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new WeldInterceptorInjectionInterceptor(interceptorClasses)), 2304);
        configuration.addPostConstructInterceptor(WeldInjectionInterceptor.FACTORY, 3328);
    }

    private static ServiceName addWeldInterceptorBindingService(ServiceTarget target, ComponentConfiguration configuration, Class<?> componentClass, String beanName, ServiceName weldServiceName, ServiceName weldStartService, String beanDeploymentArchiveId, ComponentInterceptorSupport componentInterceptorSupport) {
        ServiceName bindingServiceName = configuration.getComponentDescription().getServiceName().append(WeldInterceptorBindingsService.SERVICE_NAME);
        ServiceBuilder sb = target.addService(bindingServiceName);
        Consumer interceptorBindingsConsumer = sb.provides(new ServiceName[]{bindingServiceName});
        Supplier weldContainerSupplier = sb.requires(weldServiceName);
        sb.requires(weldStartService);
        sb.setInstance((Service)new WeldInterceptorBindingsService(interceptorBindingsConsumer, weldContainerSupplier, beanDeploymentArchiveId, beanName, componentClass, componentInterceptorSupport));
        sb.install();
        return bindingServiceName;
    }

    private static void addJsr299BindingsCreateInterceptor(ComponentConfiguration configuration, ComponentDescription description, String beanName, ServiceName weldServiceName, ServiceBuilder<?> builder, ServiceName bindingServiceName, ComponentInterceptorSupport componentInterceptorSupport) {
        Supplier weldContainerSupplier = builder.requires(weldServiceName);
        Supplier interceptorBindingsSupplier = builder.requires(bindingServiceName);
        Jsr299BindingsCreateInterceptor createInterceptor = new Jsr299BindingsCreateInterceptor(weldContainerSupplier, interceptorBindingsSupplier, description.getBeanDeploymentArchiveId(), beanName, componentInterceptorSupport);
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)createInterceptor), 1664);
    }

    private static void addCommonLifecycleInterceptionSupport(ComponentConfiguration configuration, ServiceBuilder<?> builder, ServiceName bindingServiceName, ServiceName beanManagerServiceName, ComponentInterceptorSupport componentInterceptorSupport) {
        configuration.addPreDestroyInterceptor(Jsr299BindingsInterceptor.factory((InterceptionType)InterceptionType.PRE_DESTROY, builder, (ServiceName)bindingServiceName, (ComponentInterceptorSupport)componentInterceptorSupport), 2816);
        configuration.addAroundConstructInterceptor(Jsr299BindingsInterceptor.factory((InterceptionType)InterceptionType.AROUND_CONSTRUCT, builder, (ServiceName)bindingServiceName, (ComponentInterceptorSupport)componentInterceptorSupport), 3072);
        configuration.addPostConstructInterceptor(Jsr299BindingsInterceptor.factory((InterceptionType)InterceptionType.POST_CONSTRUCT, builder, (ServiceName)bindingServiceName, (ComponentInterceptorSupport)componentInterceptorSupport), 4096);
        EjbRequestScopeActivationInterceptor.Factory postConstructRequestContextActivationFactory = new EjbRequestScopeActivationInterceptor.Factory(beanManagerServiceName);
        configuration.addPostConstructInterceptor((InterceptorFactory)postConstructRequestContextActivationFactory, 3712);
        configuration.addAroundConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)WeldConstructionStartInterceptor.INSTANCE), 2560);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static abstract class AbstractInjectionTargetDelegatingInterceptor
    implements Interceptor {
        private AbstractInjectionTargetDelegatingInterceptor() {
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ManagedReference reference = (ManagedReference)((ComponentInstance)context.getPrivateData(ComponentInstance.class)).getInstanceData(BasicComponentInstance.INSTANCE_KEY);
            if (reference != null) {
                this.run(reference.getInstance());
            }
            return context.proceed();
        }

        protected abstract void run(Object var1);
    }
}

