/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.webservices.injection.WSComponentDescription;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.injection.NonContextualComponentInjectionTarget;
import org.jboss.as.weld.injection.WeldInjectionContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldComponentService
implements Service<WeldComponentService> {
    private final Class<?> componentClass;
    private final InjectedValue<WeldBootstrapService> weldContainer;
    private final String ejbName;
    private final Set<Class<?>> interceptorClasses;
    private final Map<Class<?>, InjectionTarget> interceptorInjections = new HashMap();
    private final ClassLoader classLoader;
    private final String beanDeploymentArchiveId;
    private final ComponentDescription componentDescription;
    private final boolean delegateProduce;
    private InjectionTarget injectionTarget;
    private Bean<?> bean;
    private BeanManagerImpl beanManager;

    public WeldComponentService(Class<?> componentClass, String ejbName, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId, boolean delegateProduce, ComponentDescription componentDescription) {
        this.componentClass = componentClass;
        this.ejbName = ejbName;
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
        this.delegateProduce = delegateProduce;
        this.weldContainer = new InjectedValue();
        this.interceptorClasses = interceptorClasses;
        this.classLoader = classLoader;
        this.componentDescription = componentDescription;
    }

    public WeldInjectionContext createInjectionContext() {
        return new WeldInjectionContext((CreationalContext<?>)this.beanManager.createCreationalContext(this.bean), this.bean, this.delegateProduce, this.injectionTarget, this.interceptorInjections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            ManagedBean<?> bean;
            EjbDescriptor descriptor;
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.beanManager = ((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanDeploymentArchiveId);
            for (Class<?> interceptor : this.interceptorClasses) {
                this.interceptorInjections.put(interceptor, (InjectionTarget)new NonContextualComponentInjectionTarget(interceptor, null, this.beanManager));
            }
            if (this.ejbName != null && (descriptor = this.beanManager.getEjbDescriptor(this.ejbName)) != null) {
                this.bean = this.beanManager.getBean(descriptor);
            }
            if (this.bean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)this.bean;
                this.injectionTarget = sessionBean.getInjectionTarget();
                return;
            }
            if (this.componentDescription instanceof WSComponentDescription && (bean = this.findManagedBeanForWSComponent(this.componentClass)) != null) {
                this.injectionTarget = bean.getInjectionTarget();
                return;
            }
            NonContextualComponentInjectionTarget injectionTarget = new NonContextualComponentInjectionTarget(this.componentClass, this.bean, this.beanManager);
            this.injectionTarget = this.componentDescription instanceof MessageDrivenComponentDescription || this.componentDescription instanceof WebComponentDescription ? this.beanManager.fireProcessInjectionTarget(injectionTarget.getAnnotated(), injectionTarget) : injectionTarget;
            ((InjectionTargetService)this.beanManager.getServices().get(InjectionTargetService.class)).validateProducer(injectionTarget);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    private <T> ManagedBean<T> findManagedBeanForWSComponent(Class<T> definingClass) {
        Set beans = this.beanManager.getBeans(definingClass, new Annotation[]{AnyLiteral.INSTANCE});
        Iterator i = beans.iterator();
        while (i.hasNext()) {
            Bean bean = (Bean)i.next();
            if (bean instanceof ManagedBean && bean.getBeanClass().equals(definingClass)) continue;
            i.remove();
        }
        if (beans.isEmpty()) {
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Could not find bean for %s, interception and decoration will be unavailable", this.componentClass);
            return null;
        }
        if (beans.size() > 1) {
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Multiple beans for %s : %s ", this.componentClass, beans);
        }
        return (ManagedBean)Reflections.cast(beans.iterator().next());
    }

    public synchronized void stop(StopContext context) {
        this.injectionTarget = null;
        this.interceptorInjections.clear();
        this.bean = null;
    }

    public synchronized WeldComponentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }
}

