package org.jboss.as.xts.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-14T18:11:40-0800")
public class XtsAsLogger_$logger extends DelegatingBasicLogger implements XtsAsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = XtsAsLogger_$logger.class.getName();
    public XtsAsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String txBridgeInboundRecoveryServiceFailedToStart = "WFLYXTS0001: TxBridge inbound recovery service start failed";
    protected String txBridgeInboundRecoveryServiceFailedToStart$str() {
        return txBridgeInboundRecoveryServiceFailedToStart;
    }
    @Override
    public final StartException txBridgeInboundRecoveryServiceFailedToStart() {
        final StartException result = new StartException(String.format(getLoggingLocale(), txBridgeInboundRecoveryServiceFailedToStart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String txBridgeOutboundRecoveryServiceFailedToStart = "WFLYXTS0002: TxBridge outbound recovery service start failed";
    protected String txBridgeOutboundRecoveryServiceFailedToStart$str() {
        return txBridgeOutboundRecoveryServiceFailedToStart;
    }
    @Override
    public final StartException txBridgeOutboundRecoveryServiceFailedToStart() {
        final StartException result = new StartException(String.format(getLoggingLocale(), txBridgeOutboundRecoveryServiceFailedToStart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xtsServiceFailedToStart = "WFLYXTS0003: XTS service start failed";
    protected String xtsServiceFailedToStart$str() {
        return xtsServiceFailedToStart;
    }
    @Override
    public final StartException xtsServiceFailedToStart() {
        final StartException result = new StartException(String.format(getLoggingLocale(), xtsServiceFailedToStart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xtsServiceIsNotStarted = "WFLYXTS0004: Service not started";
    protected String xtsServiceIsNotStarted$str() {
        return xtsServiceIsNotStarted;
    }
    @Override
    public final IllegalStateException xtsServiceIsNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), xtsServiceIsNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rejectingCallBecauseNotPartOfXtsTx() {
        super.log.logf(FQCN, WARN, null, rejectingCallBecauseNotPartOfXtsTx$str());
    }
    private static final String rejectingCallBecauseNotPartOfXtsTx = "WFLYXTS0009: Rejecting call because it is not part of any XTS transaction";
    protected String rejectingCallBecauseNotPartOfXtsTx$str() {
        return rejectingCallBecauseNotPartOfXtsTx;
    }
    @Override
    public final void cannotGetTransactionStatus(final MessageContext ctx, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotGetTransactionStatus$str(), ctx);
    }
    private static final String cannotGetTransactionStatus = "WFLYXTS0010: Cannot get transaction status on handling context %s";
    protected String cannotGetTransactionStatus$str() {
        return cannotGetTransactionStatus;
    }
}
