/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.bundleextractor.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.wiperdog.bundleextractor.BundleExtractor;

public class BundleExtractorImpl
implements BundleExtractor {
    private File listResources;
    public String MANIFEST_ATTRIBUTE = "Destination";
    private List<String> repositories;

    @Override
    public File getListResources() {
        return this.listResources;
    }

    @Override
    public boolean processListResources() {
        List<Map> listBundle = this.readResourceFile(this.listResources);
        for (Map bundle : listBundle) {
            String location = this.processResource(bundle);
            if (location != null && !"".equals(location)) {
                File gotBundle = new File(location);
                this.extractPackage(gotBundle);
            }
            bundle.put("getit", false);
        }
        this.rewriteFile(listBundle);
        return true;
    }

    @Override
    public String processResource(Map bundle) {
        try {
            boolean getit = (Boolean)bundle.get("getit");
            if (getit) {
                String groupId = (String)bundle.get("groupId");
                String artifactId = (String)bundle.get("artifactId");
                String version = (String)bundle.get("version");
                String location = (String)bundle.get("location");
                if (!("".equals(groupId) || "".equals(artifactId) || "".equals(version) || "".equals(location))) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("mvn org.apache.maven.plugins:maven-dependency-plugin:2.8:get ");
                    if (version != null && !version.equals("")) {
                        sb.append("-Dartifact=" + groupId + ":" + artifactId + ":" + version + " ");
                    } else {
                        sb.append("-Dartifact=" + groupId + ":" + artifactId + ":LATEST" + " ");
                    }
                    sb.append("-Ddest=" + location + " ");
                    String repoStr = "-DremoteRepositories=";
                    for (String repo : this.repositories) {
                        repoStr = repoStr + repo + ",";
                    }
                    if (repoStr.trim().endsWith(",")) {
                        repoStr = repoStr.substring(0, repoStr.lastIndexOf(","));
                    }
                    sb.append(repoStr + " ");
                    String result = this.executeCommand(sb.toString());
                    if (!"".equals(result)) {
                        System.out.println(result);
                        return location;
                    }
                }
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void extractPackage(File packageBundle) {
        try {
            if (!packageBundle.exists()) {
                System.out.println("Package bundle not found: " + packageBundle.getAbsolutePath());
                return;
            }
            JarFile jar = new JarFile(packageBundle);
            String destination = jar.getManifest().getMainAttributes().getValue(this.MANIFEST_ATTRIBUTE);
            if (destination == null || "".equals(destination)) {
                System.out.println("Destination in MANIFEST is empty.");
                return;
            }
            File dest = new File(System.getProperty("felix.home") + File.separator + destination);
            dest.mkdirs();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                File f = new File(System.getProperty("felix.home") + File.separator + destination + File.separator + entry.getName());
                if (entry.getName().contains("manifest.mf") || entry.getName().contains("META-INF/")) {
                    System.out.println("Abort: " + f.getName());
                    continue;
                }
                if (entry.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                System.out.println("-Extract " + entry.getName());
                InputStream is = jar.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public String executeCommand(String cmd) {
        StringBuffer output = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return output.toString();
    }

    public void rewriteFile(List<Map> listBundle) {
        try {
            FileWriter fw = new FileWriter(this.listResources.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            StringBuffer sb = new StringBuffer();
            for (Map bundle : listBundle) {
                for (Object key : bundle.keySet()) {
                    sb.append(bundle.get(key) + ",");
                }
            }
            bw.write(sb.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Map> readResourceFile(File listResource) {
        ArrayList<Map> listBundle = new ArrayList<Map>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(listResource));
            while ((line = br.readLine()) != null) {
                String[] values = line.split(",");
                LinkedHashMap<String, Object> bundle = new LinkedHashMap<String, Object>();
                bundle.put("groupId", values[0]);
                bundle.put("artifactId", values[1]);
                bundle.put("version", values[2]);
                bundle.put("location", values[3]);
                bundle.put("getit", values[4] != null ? Boolean.valueOf(values[5]) : true);
                listBundle.add(bundle);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return listBundle;
    }

    @Override
    public void setListResources(File listResources) {
        this.listResources = listResources;
    }

    @Override
    public List<String> getRepositories() {
        return this.repositories;
    }

    @Override
    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }
}

