/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.DateBuilder;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.UnableToInterruptJobException;
import org.wiperdog.jobmanager.internal.JobResultImpl;

public abstract class AbstractGenericJob
implements InterruptableJob {
    public static final String KEY_MAXRUNTIME = "MAXRUNTIME";
    private static final String EMPTYGROUP = "__EMPTYGROUP";
    public static final int DEF_MAX_HISTORYDEPTH = 5;
    protected Thread me;
    private boolean bRun = true;
    protected String lastMsg = "";
    protected Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");

    protected abstract Object doJob(JobExecutionContext var1) throws Throwable;

    protected final void setFailed(JobExecutionContext context) {
        this.logger.trace((Object)("AbstractGenericJob.setFailed(" + context.toString() + ")"));
        JobDataMap data = context.getMergedJobDataMap();
        this.setFailed(data);
    }

    protected final void setFailed(JobDataMap data) {
        this.logger.trace((Object)("AbstractGenericJob.setFailed(" + data.toString() + ")"));
        data.put("executionfailed", (Object)true);
    }

    private JobDetail setSuicide(JobExecutionContext context) {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        Long maxRunTime = (Long)data.get(KEY_MAXRUNTIME);
        this.logger.trace((Object)("setting suicide job for :" + context.getJobDetail().getKey().getName() + ", time: " + maxRunTime));
        if (maxRunTime != null && maxRunTime > 0L && !maxRunTime.equals(Long.MAX_VALUE)) {
            JobKey key = context.getJobDetail().getKey();
            JobDataMap datamap = new JobDataMap();
            datamap.put("jobkey", (Object)key);
            JobDetail sj = JobBuilder.newJob().usingJobData(datamap).ofType(SuicideJob.class).build();
            Trigger t = TriggerBuilder.newTrigger().forJob(sj).startAt(DateBuilder.futureDate(maxRunTime.intValue(), DateBuilder.IntervalUnit.MILLISECOND)).build();
            try {
                context.getScheduler().scheduleJob(sj, t);
                return sj;
            }
            catch (SchedulerException e) {
                this.logger.warn((Object)"failed to setup suicide job");
                this.logger.debug((Object)e);
            }
        } else {
            this.logger.trace((Object)"maxruntime is not specified or NAN");
        }
        return null;
    }

    private void cancelSuicide(JobExecutionContext context, JobDetail cancelJob) {
        try {
            context.getScheduler().deleteJob(cancelJob.getKey());
        }
        catch (SchedulerException e) {
            this.logger.trace((Object)"failed to delete suicide job", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(JobExecutionContext context) throws JobExecutionException {
        this.logger.trace((Object)("AbstractGenericJob.execute(" + context.toString() + ")"));
        this.me = Thread.currentThread();
        JobDataMap data = context.getMergedJobDataMap();
        Set reason = (Set)data.get("prohibit");
        this.logger.trace((Object)("\tjobData(prohibit) = " + (reason == null ? "null" : reason.toString())));
        if (reason != null && !reason.isEmpty()) {
            context.setResult(null);
            this.logger.trace((Object)("\tjob(" + context.getJobDetail().getKey() + ") was prohibited so returning without doing anythig"));
            return;
        }
        Trigger trigger = context.getTrigger();
        this.logger.trace((Object)("\tjob(" + trigger.getJobKey().toString() + ") is now starting."));
        try {
            JobDetail suicideJob = this.setSuicide(context);
            JobDataMap datamap = context.getJobDetail().getJobDataMap();
            JobResultImpl jresult = (JobResultImpl)datamap.get("jobresult");
            jresult = jresult == null ? new JobResultImpl(trigger.getJobKey().getName()) : new JobResultImpl(jresult);
            datamap.put("jobresult", (Object)jresult);
            jresult.setStartedAt(new Date());
            Object ro = null;
            try {
                ro = this.doJob(context);
                context.setResult(ro);
                jresult.setResult(ro);
                jresult.setMessage(this.lastMsg);
                jresult.setEndedAt(new Date());
            }
            catch (InterruptedException e) {
                jresult.setInterruptedAt(new Date());
            }
            catch (Throwable t) {
                this.logger.debug((Object)"doJob() failed", t);
            }
            finally {
                if (suicideJob != null) {
                    this.logger.trace((Object)("cancelling suicide job" + suicideJob.getKey().getName()));
                    this.cancelSuicide(context, suicideJob);
                }
                this.logger.trace((Object)("\tjob(" + trigger.getJobKey().toString() + ") finished, jobData:" + datamap.toString()));
            }
        }
        catch (Throwable t) {
            this.logger.info((Object)("\tjob(" + trigger.getJobKey().getName() + ") execution failed,  Throwable:" + t.getMessage()));
            throw new JobExecutionException(t);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.logger.trace((Object)"AbstractGenericJob.interrupt()");
        this.bRun = false;
        if (this.me != null) {
            this.me.interrupt();
        }
    }

    public static final class SuicideJob
    implements InterruptableJob {
        private Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
        public static final String KEY_JOBKEY = "jobkey";

        public SuicideJob() {
            this.logger.trace((Object)"RuntimeLimitterJob.RuntimeLimitterJob()");
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            this.logger.trace((Object)"RuntimeLimitterJob.execute()");
            this.logger.debug((Object)"interrupting job");
            JobKey jobkey = (JobKey)context.getMergedJobDataMap().get(KEY_JOBKEY);
            try {
                JobDetail targetJob = context.getScheduler().getJobDetail(jobkey);
                if (targetJob == null) {
                    this.logger.info((Object)"The job going to interrupt is already disappeared");
                    return;
                }
                context.getScheduler().interrupt(jobkey);
            }
            catch (UnableToInterruptJobException e) {
                this.logger.debug((Object)"\terror on interrupt:", (Throwable)e);
            }
            catch (SchedulerException e) {
                this.logger.debug((Object)"\terror on interrupt:", (Throwable)e);
            }
        }

        public void interrupt() throws UnableToInterruptJobException {
            this.logger.trace((Object)"RuntimeLimitterJob.interrupt()");
        }
    }
}

