/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import org.apache.log4j.Logger;
import org.quartz.JobKey;
import org.wiperdog.jobmanager.ConditionBoardException;
import org.wiperdog.jobmanager.Flow;
import org.wiperdog.jobmanager.Predecessor;
import org.wiperdog.jobmanager.Terminal;

public abstract class AbstractTerminal
implements Terminal {
    protected final JobKey jobkey;
    protected final String id;
    private final Flow inflow;
    private String alias;
    private final Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.id + "): inflow : " + (this.inflow == null ? "null" : this.inflow.getId());
    }

    protected abstract void update(boolean var1);

    protected AbstractTerminal(String name, JobKey jobkey) {
        String idname = name;
        this.inflow = new InFlow();
        if (name == null || name.length() == 0) {
            idname = "_Terminal_for_" + jobkey.getName();
        }
        this.logger.trace((Object)("AbstractTerminal.AbstractTerminal(" + idname + "," + jobkey.toString() + ")"));
        this.id = idname;
        this.jobkey = jobkey;
    }

    public void setAlias(String alias) {
        this.logger.trace((Object)("AbstractTerminal.setAlias(" + alias + ")"));
        this.alias = alias;
    }

    public String getAlias() {
        this.logger.trace((Object)"AbstractTerminal.getAlias()");
        return this.alias;
    }

    public String getId() {
        this.logger.trace((Object)"AbstractTerminal.getId()");
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public JobKey getJobKey() {
        return this.jobkey;
    }

    public void connectUpperFlow(Predecessor f) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractTerminal.connectUpperFlow(" + f.toString() + ")"));
        f.addOutFlow(this.inflow);
    }

    public void disconnectUpperFlow(Predecessor p) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractTerminal.disconnectUpperFlow(" + p.toString() + ")"));
        p.deleteOutFlow(this.inflow);
    }

    private final class InFlow
    implements Flow {
        public InFlow() {
            AbstractTerminal.this.logger.trace((Object)"AbstractTerminal.InFlow.InFlow()");
        }

        public void call(boolean v) {
            AbstractTerminal.this.logger.trace((Object)("AbstractTerminal.InFlow.call(" + v + ")"));
            AbstractTerminal.this.update(v);
        }

        public String getId() {
            AbstractTerminal.this.logger.trace((Object)"AbstractTerminal.InFlow.getId()");
            return AbstractTerminal.this.id;
        }
    }
}

