/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.PropertySettingJobFactory;
import org.wiperdog.jobmanager.JobClass;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.JobManagerException;
import org.wiperdog.jobmanager.JobResult;
import org.wiperdog.jobmanager.dsl.Parser;
import org.wiperdog.jobmanager.internal.JobClassImpl;
import org.wiperdog.jobmanager.internal.JobFacadeImpl;
import org.wiperdog.rshell.api.RShellProvider;
import org.xml.sax.SAXException;

public class Activator
implements BundleActivator {
    public static final String PID = "com.insight_tec.pi.jobmanager";
    public static final String LOGGERNAME = "com.insight_tec.pi.jobmanager";
    public static final String KEY_MAXRECEIVESIZE = "shell.maxreceivesize";
    public static final String KEY_MAXHISTORYDEPTH = "maxhistorydepth";
    private BundleContext context;
    private Logger logger = Logger.getLogger(Activator.class);
    private Scheduler scheduler;
    private SchedulerFactory sf;
    private JobFacade jf;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.initSchedulerCore();
        context.registerService(JobFacade.class.getName(), (Object)this.jf, null);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", "scheduler");
        ((Dictionary)props).put("osgi.command.function", new String[]{"load", "list"});
        context.registerService(GogoCommand.class.getName(), (Object)new GogoCommand(), props);
        ServiceTracker tracker = new ServiceTracker(context, RShellProvider.class.getName(), (ServiceTrackerCustomizer)new CommanderServiceTrackerCustomizer());
        tracker.open();
        props = new Hashtable();
        ((Dictionary)props).put("service.pid", "com.insight_tec.pi.jobmanager");
        context.registerService(ManagedService.class.getName(), (Object)new Config(), props);
    }

    public void stop(BundleContext context) throws Exception {
        this.finishSchedulerCore();
    }

    private void initSchedulerCore() {
        this.sf = new StdSchedulerFactory();
        try {
            this.scheduler = this.sf.getScheduler();
            PropertySettingJobFactory jfactory = new PropertySettingJobFactory();
            jfactory.setWarnIfPropertyNotFound(false);
            this.scheduler.setJobFactory(jfactory);
            this.jf = new JobFacadeImpl(this.scheduler);
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            this.logger.trace((Object)"", (Throwable)e);
        }
        catch (JobManagerException e) {
            this.logger.trace((Object)"", (Throwable)e);
        }
    }

    private void finishSchedulerCore() {
        try {
            this.jf = null;
            this.scheduler.shutdown();
            this.scheduler = null;
            this.sf = null;
        }
        catch (SchedulerException e) {
            this.logger.trace((Object)"", (Throwable)e);
        }
    }

    private class CommanderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private CommanderServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object svc = Activator.this.context.getService(reference);
            ((JobFacadeImpl)Activator.this.jf).setCommander((RShellProvider)svc);
            return svc;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    }

    private class GogoCommand {
        private GogoCommand() {
        }

        private void showJobDataMap(String indent, JobDataMap datamap) {
            Set entries = datamap.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getValue() instanceof String[]) {
                    System.out.println(indent + (String)entry.getKey() + ":");
                    for (String e : (String[])entry.getValue()) {
                        System.out.println(indent + "  " + e);
                    }
                    continue;
                }
                System.out.println(indent + (String)entry.getKey() + ":" + entry.getValue().toString());
            }
        }

        public void load(String[] args) {
            Parser parser = new Parser(Activator.this.jf, false);
            if (args.length > 0) {
                String filepath;
                if (args[0].startsWith("/")) {
                    filepath = args[0];
                } else {
                    filepath = System.getProperty("felix.home");
                    if (filepath == null || filepath.length() == 0) {
                        filepath = System.getProperty("user.dir");
                    }
                    filepath = filepath + "/" + args[0];
                }
                File fin = new File(filepath);
                if (fin.isFile() && fin.canRead()) {
                    try {
                        parser.parse(fin);
                        System.out.println("loaded '" + fin.getAbsolutePath() + "'");
                    }
                    catch (IOException e) {
                        System.out.println("IO error '" + fin.getAbsolutePath() + "'");
                        Activator.this.logger.warn((Object)"", (Throwable)e);
                    }
                    catch (SAXException e) {
                        System.out.println("xml syntax error " + fin.getAbsolutePath() + "'");
                        Activator.this.logger.warn((Object)"", (Throwable)e);
                    }
                } else {
                    System.out.println("file is not readable or does't exist '" + fin.getAbsolutePath() + "'");
                }
            } else {
                System.out.println("need file path argument");
            }
        }

        public void list(String[] args) {
            Set<String> keys = Activator.this.jf.keySetJob();
            System.out.println("Job list - ");
            for (String name : keys) {
                JobDetail job = null;
                try {
                    job = Activator.this.jf.getJob(name);
                }
                catch (JobManagerException e) {
                    // empty catch block
                }
                JobDataMap datamap = job.getJobDataMap();
                System.out.println("    " + name);
                System.out.println("        " + job.getJobClass().getClass().getSimpleName());
                this.showJobDataMap("        ", datamap);
                List<JobResult> results = Activator.this.jf.getJobResult(name);
                if (results == null) continue;
                System.out.println("        executeion results: ");
                for (JobResult r : results) {
                    if (r == null) continue;
                    System.out.println("");
                    System.out.println("            result: " + (r.getResult() != null ? r.getResult().toString() : "null"));
                    System.out.println("            started: " + r.getStartedAt());
                    System.out.println("            Interrupted: " + r.getInterruptedAt());
                    System.out.println("            ended: " + r.getEndedAt());
                    System.out.println("            pended: " + r.getPendedAt());
                    System.out.println("            message: " + r.getMessage());
                }
            }
            System.out.println("Trigger list - ");
            Set<TriggerKey> tkeys = Activator.this.jf.getTriggerKeys();
            for (TriggerKey key : tkeys) {
                Trigger t = Activator.this.jf.getTrigger(key);
                System.out.println("    " + t.getKey().toString());
                System.out.println("        startTime: " + t.getStartTime());
                System.out.println("        previousFireTime: " + t.getPreviousFireTime());
                System.out.println("        nextFireTime: " + t.getNextFireTime());
            }
            System.out.println("Class list - ");
            keys = Activator.this.jf.keySetClass();
            for (String name : keys) {
                JobClass c = Activator.this.jf.getJobClass(name);
                System.out.println("    " + name);
                System.out.println("        concurrency: " + c.getConcurrency());
                System.out.println("        maxWaitTime: " + c.getMaxWaitTime());
                System.out.println("        maxRunTime: " + c.getMaxRunTime());
                Object[] vq = ((JobClassImpl)c).getVetoedQueue();
                System.out.println("        vetoed queue:");
                for (Object o : vq) {
                    System.out.println("          " + o.toString());
                }
            }
        }
    }

    private class Config
    implements ManagedService {
        private Config() {
        }

        public void updated(Dictionary properties) throws ConfigurationException {
            if (properties != null) {
                String strMaxReceiveSize = (String)properties.get(Activator.KEY_MAXRECEIVESIZE);
                try {
                    ((JobFacadeImpl)Activator.this.jf).setMaxReceiveSize(Integer.parseInt(strMaxReceiveSize));
                }
                catch (NumberFormatException e) {
                    Activator.this.logger.trace((Object)"invalied number fomat in property(shell.maxreceivesize)");
                }
                String strMaxHistory = (String)properties.get(Activator.KEY_MAXHISTORYDEPTH);
                try {
                    ((JobFacadeImpl)Activator.this.jf).setMaxHistoryDepth(Integer.parseInt(strMaxHistory));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

